/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client;

import com.sap.core.connectivity.tunnel.client.handshake.ClientHandshaker;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.handlers.MessagePacketHandler;
import com.sap.core.connectivity.tunnel.core.handlers.PayloadTracer;
import com.sap.core.connectivity.tunnel.core.handlers.TunnelErrorHandler;
import com.sap.core.connectivity.tunnel.core.handlers.TunnelProtocolDecoder;
import com.sap.core.connectivity.tunnel.core.handlers.TunnelProtocolEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.timeout.IdleStateHandler;

public class TunnelClientChannelInitializer
extends ChannelInitializer<Channel> {
    private final ConnectivityContext connectivityContext;
    private final String tunnelId;
    private final ClientHandshaker tunnelClientHandshaker;
    private final int idleTime;

    public TunnelClientChannelInitializer(ConnectivityContext connectivityContext, String tunnelId, ClientHandshaker tunnelClientHandshaker, int idleTime) {
        this.tunnelId = tunnelId;
        this.tunnelClientHandshaker = tunnelClientHandshaker;
        this.connectivityContext = connectivityContext;
        this.idleTime = idleTime;
    }

    protected void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.idleTime));
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpRequestEncoder());
        pipeline.addLast("httpDecoder", (ChannelHandler)new HttpResponseDecoder());
        pipeline.addLast("protocolEncoder", (ChannelHandler)new TunnelProtocolEncoder());
        pipeline.addLast("tunnelClientHandshaker", (ChannelHandler)this.tunnelClientHandshaker);
        pipeline.addLast("protocolDecoder", (ChannelHandler)new TunnelProtocolDecoder(this.connectivityContext));
        pipeline.addLast("payloadTracer", (ChannelHandler)new PayloadTracer());
        pipeline.addLast("messagePacketHandler", (ChannelHandler)new MessagePacketHandler(this.tunnelId, this.connectivityContext));
        pipeline.addLast("tunnelErrorHandler", (ChannelHandler)new TunnelErrorHandler());
    }
}

