/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.certificate;

import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.xml.bind.DatatypeConverter;

public class PemToKeyCertificateConverter {
    public PrivateKey getPrivateKeyFromPem(String algorithm, String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyPem = this.getPrivateKeyPemPart(algorithm, pem);
        byte[] encoded = DatatypeConverter.parseBase64Binary((String)privateKeyPem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(keySpec);
    }

    public X509Certificate getCertificateFromPem(String pem) throws CertificateException {
        String pemForCertificate = this.getCertificatePemPart(pem);
        byte[] encoded = DatatypeConverter.parseBase64Binary((String)pemForCertificate);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(encoded));
        return certificate;
    }

    private String getPrivateKeyPemPart(String algorithm, String pem) {
        String prefix = String.format("-----BEGIN %s PRIVATE KEY-----", algorithm);
        String suffix = String.format("-----END %s PRIVATE KEY-----", algorithm);
        return this.substring(pem, prefix, suffix);
    }

    private String getCertificatePemPart(String pem) {
        return this.substring(pem, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
    }

    private String substring(String source, String prefix, String suffix) {
        int prefixIndex = source.indexOf(prefix);
        int suffixIndex = source.indexOf(suffix);
        return source.substring(prefixIndex + prefix.length(), suffixIndex);
    }
}

