/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.handshake;

import com.sap.core.connectivity.spi.handshake.TunnelHandshakeProtocolStorage;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.ssl.TunnelClientSSLConfigurationService;
import com.sap.core.connectivity.tunnel.client.handshake.ClientHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.ClientProtocolHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.ProxyHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeResult;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import com.sap.core.connectivity.tunnel.core.handlers.TunnelStateHandler;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeException;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public abstract class AbstractClientHandshaker
extends SimpleChannelInboundHandler<HttpResponse>
implements ClientHandshaker {
    private static final Logger log = Logger.getLogger(AbstractClientHandshaker.class);
    private final ConnectivityContext connectivityContext;
    protected final String tunnelId;
    private final String clientId;
    protected final TunnelEndpoint endpoint;
    protected final String tunnelServerHost;
    protected final String handshakeServerHost;
    protected ProxyHandshaker proxyHandshaker;
    protected ClientProtocolHandshaker protocolHandshaker;
    protected TunnelClientHandshakeFuture future;
    protected TunnelHandshakeProtocolStorage handshakeProtocolStorage;
    private String tunnelServerProtocol;
    private String notificationAgentTunnelProtocol;
    private InetSocketAddress serverAddress;
    protected TunnelClientSSLConfigurationService clientSSLConfigurationService;

    public AbstractClientHandshaker(ConnectivityContext connectivityContext, String tunnelId, TunnelEndpoint endpoint, String clientId, InetSocketAddress serverAddress, RoutingInformation routingInformation, HTTPSProxy proxy) {
        this.connectivityContext = connectivityContext;
        this.tunnelId = tunnelId;
        this.clientId = clientId;
        this.endpoint = endpoint;
        this.serverAddress = serverAddress;
        this.tunnelServerHost = endpoint.getTunnelServerAddress().getHostName();
        this.handshakeServerHost = serverAddress.getHostName();
        this.protocolHandshaker = new ClientProtocolHandshaker(tunnelId, clientId, serverAddress, routingInformation);
        if (proxy != null) {
            this.proxyHandshaker = new ProxyHandshaker(serverAddress, proxy);
        }
        this.handshakeProtocolStorage = (TunnelHandshakeProtocolStorage)TunnelConsumableServices.getService(TunnelHandshakeProtocolStorage.class);
        this.clientSSLConfigurationService = (TunnelClientSSLConfigurationService)TunnelConsumableServices.getService(TunnelClientSSLConfigurationService.class);
    }

    protected void prepareSSLCommunication(ChannelPipeline channelPipeline) {
        this.clientSSLConfigurationService.addSSLHandler(channelPipeline, this.endpoint, this.serverAddress);
        this.clientSSLConfigurationService.addSSLHandshakeValidator(channelPipeline, this.serverAddress);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            throw new TunnelHandshakeException(String.format("Timed out while waiting for response from server for tunnel ID: %s", this.tunnelId));
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.future != null && !this.future.isDone()) {
            this.future.setFailure((Throwable)new TunnelHandshakeException("Connection closed by server"));
        }
        super.channelInactive(ctx);
    }

    protected void handleProxyHandshakeResponse(ChannelHandlerContext ctx, HttpResponse response) {
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            log.error((Object)("Invalid proxy response: " + response));
            throw new TunnelHandshakeException("Invalid proxy response status: " + response.status());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received proxy response:\n" + response));
        }
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.replace(HttpResponseDecoder.class, "responseDecoder", (ChannelHandler)new HttpResponseDecoder());
    }

    protected void handleTunnelHandshakeResponse(ChannelHandlerContext ctx, HttpResponse response) throws TunnelRegistrationException {
        Channel channel = ctx.channel();
        if (!this.protocolHandshaker.isHandshakeComplete()) {
            channel.config().setAutoRead(false);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Disabled reading from channel %s for tunnel ID: %s", channel, this.tunnelId));
            }
            TunnelClientHandshakeResult handshakeResult = this.protocolHandshaker.finishHandshake(channel, response);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Handshake with tunnel server completed successfully for tunnel ID: %s", this.tunnelId));
            }
            ctx.pipeline().remove(IdleStateHandler.class);
            ctx.pipeline().addAfter("wsdecoder", "tunnelStateHandler", (ChannelHandler)new TunnelStateHandler(this.tunnelId, true));
            this.connectivityContext.getTunnelRegistry().registerTunnelChannel(this.tunnelId, this.clientId, channel);
            ctx.pipeline().remove((ChannelHandler)this);
            this.future.setSuccess(handshakeResult);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Nothing to do. Protocol handshake already completed for tunnel ID: %s", this.tunnelId));
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpResponse response) throws Exception {
        if (!response.decoderResult().isSuccess()) {
            throw new TunnelHandshakeException("Invalid handshake response received by tunnel client: " + response.decoderResult().cause());
        }
        this.handleChannelRead(ctx, response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.future != null) {
            this.future.setFailure(cause);
        }
    }

    protected abstract void handleChannelRead(ChannelHandlerContext var1, HttpResponse var2) throws Exception;

    protected String getTunnelServerProtocol() {
        if (this.tunnelServerProtocol == null) {
            this.tunnelServerProtocol = this.handshakeProtocolStorage.getTunnelServerProtocol(this.tunnelServerHost);
        }
        return this.tunnelServerProtocol;
    }

    protected String getNotificationAgentTunnelProtocol() {
        if (this.notificationAgentTunnelProtocol == null) {
            this.notificationAgentTunnelProtocol = this.handshakeProtocolStorage.getNotificationAgentProtocol(this.tunnelServerHost);
        }
        return this.notificationAgentTunnelProtocol;
    }
}

