/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.handshake;

import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeResult;
import com.sap.core.connectivity.tunnel.core.handshake.ClientConflictHandshakeException;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeConstants;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeException;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ClientProtocolHandshaker {
    private static final Logger log = Logger.getLogger(ClientProtocolHandshaker.class);
    private final String tunnelId;
    private final String clientId;
    private final InetSocketAddress serverAddress;
    private final RoutingInformation routingInformation;
    private boolean handshakeComplete = false;

    public ClientProtocolHandshaker(String tunnelId, String clientId, InetSocketAddress serverAddress, RoutingInformation rountingInformation) {
        this.tunnelId = tunnelId;
        this.clientId = clientId;
        this.serverAddress = serverAddress;
        this.routingInformation = rountingInformation;
    }

    public void handshake(Channel channel, String tunnelProtocol) {
        String path = this.getRequestPath();
        String tunnelServerHost = MessageFormat.format("{0}:{1}", this.serverAddress.getHostString(), Integer.toString(this.serverAddress.getPort()));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)tunnelProtocol);
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)tunnelServerHost);
        request.headers().set("X-Connectivity-Tunnel-Id", (Object)this.tunnelId);
        request.headers().set("X-Connectivity-Client-Id", (Object)this.clientId);
        request.headers().set("X-Tunnel-Version", (Object)this.arrayToString(TunnelHandshakeConstants.TUNNEL_CLIENT_SUPPORTED_VERSIONS));
        if (this.routingInformation != null) {
            request.headers().set("X-Connectivity-Pool", (Object)this.routingInformation.getPool());
            request.headers().set((CharSequence)HttpHeaderNames.COOKIE, (Object)("cookie_v=" + this.routingInformation.getHostId()));
            if (this.routingInformation.getFingerprint() != null) {
                request.headers().set("X-Tunnel-Vm-Fingerprint", (Object)this.routingInformation.getFingerprint());
            }
        }
        log.info((Object)MessageFormat.format("Sending handshake request for tunnel: {0} and host {1}", this.tunnelId, tunnelServerHost));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending handshake request:\n" + request));
        }
        channel.writeAndFlush((Object)request).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelPipeline pipeline = future.channel().pipeline();
                if (future.isSuccess()) {
                    pipeline.replace(HttpRequestEncoder.class, "wsencoder", (ChannelHandler)new WebSocket13FrameEncoder(false));
                }
            }
        });
    }

    private String getRequestPath() {
        if (this.routingInformation == null || this.routingInformation.getPath() == null) {
            return "/connectivity";
        }
        return this.routingInformation.getPath();
    }

    public TunnelClientHandshakeResult finishHandshake(Channel channel, HttpResponse response) {
        if (!response.status().equals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS)) {
            log.error((Object)("Invalid status of handshake response: " + response));
            if (HttpResponseStatus.CONFLICT.code() == response.status().code()) {
                throw new ClientConflictHandshakeException("Invalid status of handshake response: " + response.status());
            }
            throw new TunnelHandshakeException("Invalid status of handshake response: " + response.status());
        }
        String upgrade = response.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
        if (upgrade == null || !upgrade.equals("connectivity") && !upgrade.equals("websocket")) {
            log.error((Object)("Invalid Upgrade header in handshake response: " + response));
            throw new TunnelHandshakeException("Invalid Upgrade header in handshake response:  " + upgrade);
        }
        String connection = response.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        if (connection == null || !connection.toLowerCase().equals(HttpHeaderValues.UPGRADE.toString().toLowerCase())) {
            log.error((Object)("Invalid Connection header in handshake response: " + response));
            throw new TunnelHandshakeException("Invalid Connection header in handshake response: " + connection);
        }
        int protocolVersion = this.extractProtocolVersion(response);
        String vmIdentifier = response.headers().get("X-Tunnel-Vm-Identifier");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received handshake response:\n" + response));
        }
        this.handshakeComplete = true;
        channel.pipeline().replace(HttpResponseDecoder.class, "wsdecoder", (ChannelHandler)new WebSocket13FrameDecoder(false, true, Integer.MAX_VALUE));
        TunnelClientHandshakeResult result = new TunnelClientHandshakeResult();
        result.setVmIdentifier(vmIdentifier);
        result.setProtocolVersion(protocolVersion);
        return result;
    }

    private int extractProtocolVersion(HttpResponse response) {
        String protocolVersionString = response.headers().get("X-Tunnel-Version");
        try {
            return Integer.parseInt(protocolVersionString);
        }
        catch (Exception e) {
            log.error((Object)("Invalid X-Tunnel-Version header in handshake response: " + response));
            throw new TunnelHandshakeException("Invalid X-Tunnel-Version header in handshake response: " + protocolVersionString, (Throwable)e);
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private String arrayToString(int[] array) {
        return Arrays.toString(array).replaceAll("\\[|\\]", "");
    }
}

