/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.handshake;

import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import com.sap.core.connectivity.tunnel.core.util.GeneralValidator;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import javax.xml.bind.DatatypeConverter;

public class ProxyHandshaker {
    private final InetSocketAddress serverAddress;
    private final HTTPSProxy proxy;

    ProxyHandshaker(InetSocketAddress serverAddress, HTTPSProxy proxy) {
        this.serverAddress = serverAddress;
        this.proxy = proxy;
    }

    public void handshake(Channel channel) {
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, this.serverAddress.getHostName() + ":" + this.serverAddress.getPort());
        httpRequest.headers().set("Host", (Object)this.serverAddress.getHostName());
        httpRequest.headers().set("User-Agent", (Object)"SCC Tunnel Client");
        httpRequest.headers().set("Proxy-Connection", (Object)"keep-alive");
        if (GeneralValidator.isNotEmpty((String)this.proxy.getUser())) {
            httpRequest.headers().set("Proxy-Authorization", (Object)this.getAuthorizationHeaderValue());
        }
        channel.writeAndFlush((Object)httpRequest).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
    }

    private String getAuthorizationHeaderValue() {
        String proxyPass = this.proxy.getPassword() != null ? this.proxy.getPassword() : "";
        String credentials = this.proxy.getUser() + ":" + proxyPass;
        try {
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])credentials.getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

