/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.handshake;

import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.client.handshake.AbstractClientHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import java.net.InetSocketAddress;

public class TunnelClientHandshaker
extends AbstractClientHandshaker {
    private State state;

    public TunnelClientHandshaker(ConnectivityContext connectivityContext, String tunnelId, String clientId, TunnelEndpoint endpoint, InetSocketAddress serverAddress, RoutingInformation routingInformation, HTTPSProxy proxy) {
        super(connectivityContext, tunnelId, endpoint, clientId, serverAddress, routingInformation, proxy);
        this.state = proxy != null ? State.PROXY : State.TUNNEL;
    }

    @Override
    protected void handleChannelRead(ChannelHandlerContext ctx, HttpResponse response) throws Exception {
        switch (this.state) {
            case PROXY: {
                this.handleProxyHandshakeResponse(ctx, response);
                this.state = State.TUNNEL;
                this.prepareSSLCommunication(ctx.pipeline());
                this.protocolHandshaker.handshake(ctx.channel(), this.getTunnelServerProtocol());
                break;
            }
            case TUNNEL: {
                this.handleTunnelHandshakeResponse(ctx, response);
            }
        }
    }

    @Override
    public void handshake(TunnelClientHandshakeFuture handshakeFuture) {
        this.future = handshakeFuture;
        if (this.proxyHandshaker != null) {
            this.proxyHandshaker.handshake(this.future.channel());
        } else {
            this.prepareSSLCommunication(this.future.channel().pipeline());
            this.protocolHandshaker.handshake(this.future.channel(), this.getTunnelServerProtocol());
        }
    }

    private static enum State {
        PROXY,
        TUNNEL;

    }
}

