/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.DBSystemInformation;
import com.sap.core.connectivity.tunnel.api.management.HCPVMInformation;
import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AvailableSystemsInfoRetriever {
    private static final Logger log = Logger.getLogger(AvailableSystemsInfoRetriever.class);
    private final ConnectivityContext notificationContext;
    private final TunnelConfiguration tunnelConfiguration;

    AvailableSystemsInfoRetriever(ConnectivityContext notifincationContext, TunnelConfiguration tunnelConfiguration) {
        this.notificationContext = notifincationContext;
        this.tunnelConfiguration = tunnelConfiguration;
    }

    public List<DBSystemInformation> retrieveDBSystems(String tunnelId) throws NoChannelsAvailableException, ConnectionFailedException {
        String jsonSystemsResponse = this.retrieveCloudSystems(tunnelId, ProxyProtocol.JDBC);
        return (List)new Gson().fromJson(jsonSystemsResponse, new TypeToken<ArrayList<DBSystemInformation>>(){}.getType());
    }

    public List<HCPVMInformation> retrieveHCPVMs(String tunnelId) throws NoChannelsAvailableException, ConnectionFailedException {
        String jsonSystemsResponse = this.retrieveCloudSystems(tunnelId, ProxyProtocol.SSH);
        return (List)new Gson().fromJson(jsonSystemsResponse, new TypeToken<ArrayList<HCPVMInformation>>(){}.getType());
    }

    public String retrieveCloudSystems(String tunnelId, ProxyProtocol protocol) throws NoChannelsAvailableException, ConnectionFailedException {
        Tunnel tunnel = this.notificationContext.getTunnelRegistry().getTunnel(tunnelId);
        MessagePacket packet = this.notificationContext.getMessagePacketFactory().createRequestPacket("notification", 13);
        packet.setProperty("tunnelId", tunnelId);
        packet.setProperty("forwardingTunnelProtocol", protocol.toString());
        TunnelRequestFuture future = tunnel.writeRequest(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Sent get available systems for \"{0}\"", tunnelId));
        }
        if (!future.awaitUninterruptibly((long)this.tunnelConfiguration.getAvailableCloudSystemsInfoTimeoutInSeconds(), TimeUnit.SECONDS)) {
            future.cancel(true);
            throw new ConnectionFailedException(MessageFormat.format("Available systems information was not recieved within {0} seconds", this.tunnelConfiguration.getAvailableCloudSystemsInfoTimeoutInSeconds()));
        }
        if (!future.isSuccess()) {
            throw new ConnectionFailedException(MessageFormat.format("Unable to get systems for  \"{0}\"", tunnelId), future.cause());
        }
        MessagePacket response = future.response();
        String errorMessage = response.getProperty("message");
        if (errorMessage != null) {
            throw new ConnectionFailedException(errorMessage);
        }
        return response.getProperty("cloudSystems");
    }
}

