/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.DirectTunnelOperator;
import com.sap.core.connectivity.tunnel.api.management.ProxyManagement;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelStateListener;
import com.sap.core.connectivity.tunnel.client.DirectTunnelClient;
import com.sap.core.connectivity.tunnel.client.DirectTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.DefaultConnectivityContext;
import com.sap.core.connectivity.tunnel.core.impl.proxy.ProxyManagementImpl;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import com.sap.core.connectivity.tunnel.core.util.XMLUtils;
import io.netty.channel.ChannelException;

public class DirectTunnelOperatorImpl
implements DirectTunnelOperator {
    private final DirectTunnelClient tunnelClient;
    private final ProxyManagement proxyManagement;

    DirectTunnelOperatorImpl(TunnelEndpoint endpoint, String clientId) {
        DefaultConnectivityContext context = new DefaultConnectivityContext();
        this.tunnelClient = new DirectTunnelClient(endpoint, clientId, (ConnectivityContext)context);
        this.proxyManagement = new ProxyManagementImpl((ConnectivityContext)context);
    }

    public void connect(String tunnelId, String routingInfo) throws ConnectionFailedException {
        this.connect(tunnelId, routingInfo, 1);
    }

    public void connect(String tunnelId, String routingInfo, int connectionCount) throws ConnectionFailedException {
        try {
            this.tunnelClient.connect(this.createConnectionAttributes(tunnelId, routingInfo, connectionCount));
        }
        catch (ChannelException e) {
            throw new ConnectionFailedException("Unable to establish tunnel connection", e.getCause());
        }
        catch (Exception e) {
            throw new ConnectionFailedException("Unable to establish tunnel connection", (Throwable)e);
        }
    }

    private DirectTunnelConnectionAttributes createConnectionAttributes(String tunnelId, String routingInfo, int connectionCount) {
        RoutingInformation routingInformation = (RoutingInformation)XMLUtils.deserializeFromXml(RoutingInformation.class, (String)routingInfo);
        return new DirectTunnelConnectionAttributes(tunnelId, routingInformation, connectionCount);
    }

    public void disconnect() {
        this.tunnelClient.disconnect();
    }

    public ProxyManagement getProxyManagement() {
        return this.proxyManagement;
    }

    public void addListener(TunnelStateListener connectionClosedListener) {
        this.tunnelClient.addListener(connectionClosedListener);
    }
}

