/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.routing.ForwardingTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.core.util.XMLUtils;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

class ForwardingTunnelConnectionAttributesRetriever {
    private static final Logger log = Logger.getLogger(ForwardingTunnelConnectionAttributesRetriever.class);
    private final String tunnelId;
    private final String endpoint;
    private final ConnectivityContext notificationContext;
    private final TunnelConfiguration tunnelConfiguration;

    ForwardingTunnelConnectionAttributesRetriever(String tunnelId, String endpoint, ConnectivityContext notifincationContext, TunnelConfiguration tunnelConfiguration) {
        this.tunnelId = tunnelId;
        this.endpoint = endpoint;
        this.notificationContext = notifincationContext;
        this.tunnelConfiguration = tunnelConfiguration;
    }

    public ForwardingTunnelConnectionAttributes retrieveConnectionAttributes() throws NoChannelsAvailableException, ConnectionFailedException {
        Tunnel tunnel = this.notificationContext.getTunnelRegistry().getTunnel(this.tunnelId);
        MessagePacket packet = this.notificationContext.getMessagePacketFactory().createRequestPacket("notification", 7);
        packet.setProperty("tunnelId", this.tunnelId);
        packet.setProperty("forwardingTunnelEndpoint", this.endpoint);
        TunnelRequestFuture future = tunnel.writeRequest(packet);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Sent open forwarding tunnel request for tunnel id \"{0}\", and endpoint \"{1}\" ", this.tunnelId, this.endpoint));
        }
        if (!future.awaitUninterruptibly((long)this.tunnelConfiguration.getForwardingTunnelRoutingInfoTimeoutInSeconds(), TimeUnit.SECONDS)) {
            future.cancel(true);
            throw new ConnectionFailedException(MessageFormat.format("Forwarding tunnel was not established within {0} seconds", this.tunnelConfiguration.getForwardingTunnelRoutingInfoTimeoutInSeconds()));
        }
        if (!future.isSuccess()) {
            throw new ConnectionFailedException(MessageFormat.format("Unable to establish forwarding tunnel to endpoint \"{0}\"", this.endpoint), future.cause());
        }
        MessagePacket response = future.response();
        String errorMessage = response.getProperty("message");
        if (errorMessage != null) {
            throw new ConnectionFailedException(errorMessage);
        }
        String dbTunnelAttributesXML = response.getProperty("forwardingTunnelAttributes");
        ForwardingTunnelConnectionAttributes forwardingTunnelConnectionAttributes = (ForwardingTunnelConnectionAttributes)XMLUtils.deserializeFromXml(ForwardingTunnelConnectionAttributes.class, (String)dbTunnelAttributesXML);
        return forwardingTunnelConnectionAttributes;
    }
}

