/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.ForwardingTunnel;
import com.sap.core.connectivity.tunnel.api.management.ForwardingTunnelInformation;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.core.connectivity.tunnel.api.management.ProxyManagement;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelStateListener;
import com.sap.core.connectivity.tunnel.client.DirectTunnelClient;
import com.sap.core.connectivity.tunnel.client.DirectTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.management.ForwardingTunnelInformationImpl;
import com.sap.core.connectivity.tunnel.client.reconnect.MaxReconnectAttemptsExceededException;
import com.sap.core.connectivity.tunnel.client.reconnect.ReconnectScheduler;
import com.sap.core.connectivity.tunnel.client.reconnect.Reconnectable;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.impl.proxy.ProxyManagementImpl;
import com.sap.core.connectivity.tunnel.core.routing.ForwardingTunnelConnectionAttributes;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

class ForwardingTunnelImpl
implements ForwardingTunnel,
Reconnectable {
    private static final Logger log = Logger.getLogger(ForwardingTunnelImpl.class);
    private final DirectTunnelClient tunnelClient;
    private final String endpoint;
    private final ProxyManagement proxyManagement;
    private final ForwardingTunnelInformationImpl information = new ForwardingTunnelInformationImpl();
    private final ReconnectScheduler reconnectScheduler;
    private final TunnelStateListener tunnelStateListener;
    private final TunnelConfiguration configuration;
    protected ForwardingTunnelConnectionAttributes connectionAttributes;
    private final ConnectivityContext context;
    private int requestedConnectionCount;
    private final Lock safetyLock = new ReentrantLock();

    ForwardingTunnelImpl(DirectTunnelClient tunnelClient, ConnectivityContext context, String endpoint, ForwardingTunnelConnectionAttributes connectionAttributes) {
        this.tunnelClient = tunnelClient;
        this.endpoint = endpoint;
        this.connectionAttributes = connectionAttributes;
        this.tunnelStateListener = new ReconnectingListener();
        this.configuration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
        this.reconnectScheduler = new ReconnectScheduler(this, this.configuration.getClientMaxReconnectAttempts(), this.configuration.getClientInitialReconnectDelay());
        this.proxyManagement = new ProxyManagementImpl(context);
        this.context = context;
    }

    public void connect() throws ConnectionFailedException {
        this.connect(this.configuration.getForwardingTunnelConnectionsCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(int tunnelConnectionCount) throws ConnectionFailedException {
        this.safetyLock.lock();
        try {
            if (this.canConnect()) {
                this.requestedConnectionCount = tunnelConnectionCount;
                if (this.information.getState().equals((Object)ForwardingTunnelInformation.State.RECONNECT_FAILED)) {
                    this.reconnectTriggeredByConnect();
                } else {
                    this.attachReconnectListener();
                    this.doConnect(tunnelConnectionCount);
                }
            } else {
                log.debug((Object)("Will skip connect - current state is: " + this.information.getState()));
            }
        }
        finally {
            this.safetyLock.unlock();
        }
    }

    private boolean canConnect() {
        ForwardingTunnelInformation.State currentState = this.information.getState();
        return currentState.equals((Object)ForwardingTunnelInformation.State.DISCONNECTED) || currentState.equals((Object)ForwardingTunnelInformation.State.CONNECT_FAILED) || currentState.equals((Object)ForwardingTunnelInformation.State.RECONNECT_FAILED);
    }

    private void reconnectTriggeredByConnect() throws ConnectionFailedException {
        this.information.updateState(ForwardingTunnelInformation.State.RECONNECTING);
        this.reconnect();
        if (this.information.getState().equals((Object)ForwardingTunnelInformation.State.RECONNECT_FAILED)) {
            throw new ConnectionFailedException("Unable to re-establish forwarding tunnel.");
        }
    }

    private void doConnect(int tunnelConnectionCount) throws ConnectionFailedException {
        try {
            this.information.updateState(ForwardingTunnelInformation.State.CONNECTING);
            DirectTunnelConnectionAttributes tunnelConnectionAttributes = this.retrieveDirectTunnelConnectionAttributes(tunnelConnectionCount);
            this.tunnelClient.connect(tunnelConnectionAttributes);
            this.reconnectScheduler.reset();
            this.information.updateState(ForwardingTunnelInformation.State.CONNECTED);
            log.info((Object)String.format("Connected forwarding tunnel to '%s'", this.endpoint));
        }
        catch (ConnectionFailedException e) {
            this.information.updateState(ForwardingTunnelInformation.State.CONNECT_FAILED, e);
            throw e;
        }
        catch (Exception e) {
            this.information.updateState(ForwardingTunnelInformation.State.CONNECT_FAILED, e);
            throw new ConnectionFailedException("Unable to establish forwarding tunnel", (Throwable)e);
        }
    }

    protected DirectTunnelConnectionAttributes retrieveDirectTunnelConnectionAttributes(int tunnelConnectionCount) throws Exception {
        return new DirectTunnelConnectionAttributes(this.connectionAttributes.getTunnelId(), this.connectionAttributes.getRoutingInformation(), tunnelConnectionCount);
    }

    private void attachReconnectListener() {
        this.tunnelClient.addListener(this.tunnelStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.safetyLock.lock();
        try {
            if (this.canDisconnect()) {
                this.detachReconnectListener();
                this.reconnectScheduler.reset();
                this.stopAllProxies();
                this.tunnelClient.disconnect();
                this.information.updateState(ForwardingTunnelInformation.State.DISCONNECTED);
                log.info((Object)String.format("Disconnected forwarding tunnel to '%s'", this.endpoint));
            } else {
                log.debug((Object)("Will skip disconnect - current state is: " + this.information.getState()));
            }
        }
        finally {
            this.safetyLock.unlock();
        }
    }

    private void detachReconnectListener() {
        this.tunnelClient.removeListener(this.tunnelStateListener);
    }

    private boolean canDisconnect() {
        ForwardingTunnelInformation.State currentState = this.information.getState();
        return !currentState.equals((Object)ForwardingTunnelInformation.State.DISCONNECTED);
    }

    public void startProxy(int localProxyPort, int remotePort) throws PortUnavailableException {
        if (this.connectionAttributes == null) {
            throw new IllegalStateException(String.format("Forwarding tunnel for endpoint '%s' is not connected", this.endpoint));
        }
        String mappingId = this.connectionAttributes.getMappingEntries().getMappingId(remotePort);
        this.proxyManagement.startProxy(localProxyPort, this.connectionAttributes.getTunnelId(), mappingId, this.connectionAttributes.getProtocol());
    }

    public void stopProxy(int proxyPort) {
        this.proxyManagement.stopProxy(proxyPort);
    }

    public void stopAllProxies() {
        this.proxyManagement.stopAllProxies();
    }

    public List<Integer> getRemotePorts() {
        if (this.connectionAttributes == null) {
            throw new IllegalStateException(String.format("Forwarding tunnel for endpoint '%s' is not connected", this.endpoint));
        }
        return this.connectionAttributes.getMappingEntries().getRemotePorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() {
        this.safetyLock.lock();
        try {
            if (this.canReconnect()) {
                int connectionsToReconnectCount = this.getConnectionsToReconnectCount();
                if (connectionsToReconnectCount == 0) {
                    return;
                }
                log.debug((Object)String.format("About to reconnect %d connections", connectionsToReconnectCount));
                this.doConnect(connectionsToReconnectCount);
            } else {
                log.debug((Object)("Will skip reconnect - current state is: " + this.information.getState()));
            }
        }
        catch (ConnectionFailedException e) {
            if (!(e.getCause() instanceof NoChannelsAvailableException)) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            this.scheduleReconnect();
        }
        finally {
            this.safetyLock.unlock();
        }
    }

    private boolean canReconnect() {
        ForwardingTunnelInformation.State currentState = this.information.getState();
        return currentState.equals((Object)ForwardingTunnelInformation.State.RECONNECTING);
    }

    private int getConnectionsToReconnectCount() {
        return this.requestedConnectionCount - this.getConnectionCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReconnect() {
        this.safetyLock.lock();
        try {
            if (this.canScheduleReconnect()) {
                this.reconnectScheduler.schedule();
                this.information.updateState(ForwardingTunnelInformation.State.RECONNECTING);
            } else {
                log.debug((Object)("Will skip schedule reconnect - current state is: " + this.information.getState()));
            }
        }
        catch (MaxReconnectAttemptsExceededException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)String.format("%s: %s", e.getClass().getSimpleName(), e.getMessage()));
            }
            this.information.updateState(ForwardingTunnelInformation.State.RECONNECT_FAILED);
        }
        finally {
            this.safetyLock.unlock();
        }
    }

    private boolean canScheduleReconnect() {
        ForwardingTunnelInformation.State currentState = this.information.getState();
        return currentState.equals((Object)ForwardingTunnelInformation.State.CONNECTED) || currentState.equals((Object)ForwardingTunnelInformation.State.CONNECT_FAILED);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getDescription() {
        return this.endpoint;
    }

    public ForwardingTunnelInformation getInformation() {
        return this.information;
    }

    public int getConnectionCount() {
        if (this.connectionAttributes == null) {
            log.error((Object)String.format("Forwarding tunnel to endpoint %s has not been connected yet.", this.endpoint));
            return 0;
        }
        try {
            String tunnelId = this.connectionAttributes.getTunnelId();
            Tunnel tunnel = this.context.getTunnelRegistry().getTunnel(tunnelId);
            return tunnel.getChannelCount();
        }
        catch (NoChannelsAvailableException ex) {
            log.error((Object)("There are no active connections because of: " + ex.getMessage()));
            return 0;
        }
    }

    private class ReconnectingListener
    implements TunnelStateListener {
        private ReconnectingListener() {
        }

        public void tunnelClosed(String tunnelId) {
            ForwardingTunnelImpl.this.scheduleReconnect();
        }
    }
}

