/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.sap.core.connectivity.tunnel.api.management.ForwardingTunnelInformation;
import com.sap.core.connectivity.tunnel.core.handshake.ClientConflictHandshakeException;
import org.apache.log4j.Logger;

public class ForwardingTunnelInformationImpl
implements ForwardingTunnelInformation {
    private static final Logger logger = Logger.getLogger(ForwardingTunnelInformationImpl.class);
    private ForwardingTunnelInformation.State state = ForwardingTunnelInformation.State.DISCONNECTED;
    private Throwable error = null;
    private long startTimestamp = 0L;
    private ForwardingTunnelInformation.Reason reason = null;

    public ForwardingTunnelInformation.State getState() {
        return this.state;
    }

    public Throwable getError() {
        return this.error;
    }

    public long getConnectTime() {
        return this.startTimestamp;
    }

    public ForwardingTunnelInformation.Reason getReason() {
        return this.reason;
    }

    public void updateState(ForwardingTunnelInformation.State newState) {
        this.updateState(newState, null);
    }

    public void updateState(ForwardingTunnelInformation.State newState, Throwable newError) {
        ForwardingTunnelInformation.State oldState = this.state;
        this.state = newState;
        this.error = newError;
        if (this.error != null) {
            this.reason = newError instanceof ClientConflictHandshakeException ? ForwardingTunnelInformation.Reason.CLIENT_CONFLICT : ForwardingTunnelInformation.Reason.UNKNOWN;
        }
        if (logger.isTraceEnabled()) {
            String stateChangedMsg = String.format("State changed from %s to %s.", oldState, newState);
            if (this.error != null) {
                stateChangedMsg = stateChangedMsg.concat(String.format(" Error lead to state change: %s", this.error));
            }
            logger.trace((Object)stateChangedMsg);
        }
        this.updateTimeStamp();
    }

    private void updateTimeStamp() {
        this.startTimestamp = this.state == ForwardingTunnelInformation.State.CONNECTED ? System.currentTimeMillis() : 0L;
    }
}

