/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.management;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacketFactory;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableService;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.DBSystemInformation;
import com.sap.core.connectivity.tunnel.api.management.ForwardingTunnel;
import com.sap.core.connectivity.tunnel.api.management.HCPVMInformation;
import com.sap.core.connectivity.tunnel.api.management.NotificationTunnelInformation;
import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelInformation;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperator;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperatorListener;
import com.sap.core.connectivity.tunnel.client.DirectTunnelClient;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelClient;
import com.sap.core.connectivity.tunnel.client.management.AvailableSystemsInfoRetriever;
import com.sap.core.connectivity.tunnel.client.management.ForwardingTunnelConnectionAttributesRetriever;
import com.sap.core.connectivity.tunnel.client.management.ForwardingTunnelImpl;
import com.sap.core.connectivity.tunnel.client.management.ManagedForwardingTunnelImpl;
import com.sap.core.connectivity.tunnel.client.management.TunnelEndpointS4HANA;
import com.sap.core.connectivity.tunnel.client.notification.NotificationClient;
import com.sap.core.connectivity.tunnel.client.notification.NotificationConnectivityContext;
import com.sap.core.connectivity.tunnel.client.notification.NotificationContextProvider;
import com.sap.core.connectivity.tunnel.client.notification.NotificationContextProviderImpl;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.DefaultConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import com.sap.core.connectivity.tunnel.core.impl.protocol.MessagePacketFactoryImpl;
import com.sap.core.connectivity.tunnel.core.routing.ForwardingTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelEndpointModel;
import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelEndpointParser;
import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelIdFactory;
import com.sap.core.connectivity.tunnel.core.util.ForwardingTunnelType;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdModel;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdParser;
import com.sap.core.connectivity.tunnel.metering.DefaultMeteringMessagePacketFactory;
import com.sap.core.connectivity.tunnel.metering.MeteringMessagePacketFactory;
import com.sap.core.connectivity.tunnel.metering.api.MeteringMessagesProvider;
import com.sap.core.connectivity.tunnel.metering.client.MeteringDataSender;
import com.sap.core.connectivity.tunnel.metering.model.MeteringDataProvider;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TunnelOperatorImpl
implements TunnelOperator {
    private static final String CONNAGENT_LB = "CONNAGENT_LB";
    private Logger logger = Logger.getLogger(TunnelOperatorImpl.class);
    private final TunnelEndpoint tunnelEndpoint;
    private final String clientId;
    private final ServiceRegistry serviceRegistry;
    private final NotificationConnectivityContext notificationConnectivityContext;
    private final ConnectivityContext connectivityContext;
    private final ManagedTunnelClient tunnelClient;
    private final NotificationClient notificationClient;
    private Set<String> ownTunnelIds;

    TunnelOperatorImpl(TunnelEndpoint tunnelEndpoint, String clientId, ServiceRegistry serviceRegistry) {
        this.tunnelEndpoint = tunnelEndpoint;
        this.clientId = clientId;
        this.serviceRegistry = serviceRegistry;
        this.notificationConnectivityContext = new NotificationConnectivityContext(this.serviceRegistry);
        this.serviceRegistry.registerService(NotificationContextProvider.class, (TunnelConsumableService)new NotificationContextProviderImpl((ConnectivityContext)this.notificationConnectivityContext));
        this.connectivityContext = new DefaultConnectivityContext(this.serviceRegistry);
        this.tunnelClient = new ManagedTunnelClient(tunnelEndpoint, clientId, this.connectivityContext);
        this.notificationClient = new NotificationClient(tunnelEndpoint, clientId, this.tunnelClient, this.notificationConnectivityContext);
        this.ownTunnelIds = new HashSet<String>();
    }

    public void enableTunnels(List<String> tunnelIds) {
        this.ownTunnelIds.addAll(tunnelIds);
        this.notificationClient.subscribeTunnels(tunnelIds);
    }

    public void disableTunnels(List<String> tunnelIds) {
        this.ownTunnelIds.removeAll(tunnelIds);
        this.notificationClient.unsubscribeTunnels(tunnelIds);
    }

    public void disconnectAllTunnels() {
        MeteringDataSender meteringDataSender = this.createMeteringDataSender();
        for (String tunnelId : this.ownTunnelIds) {
            try {
                meteringDataSender.sendMeteringData(tunnelId);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Exception encountered on sending of metering data for tunnel " + tunnelId), (Throwable)e);
            }
        }
        this.notificationClient.disconnect();
    }

    public void addListener(TunnelOperatorListener listener) {
        this.notificationClient.addListener(listener);
    }

    public void removeListener(TunnelOperatorListener listener) {
        this.notificationClient.removeListener(listener);
    }

    public NotificationTunnelInformation getNotificationInformation() {
        return this.notificationClient.getNotificationTunnelInfo();
    }

    public TunnelInformation getTunnelInformation(String tunnelId) {
        return this.tunnelClient.getTunnelInformation(tunnelId);
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public ForwardingTunnel createForwardingTunnel(String tunnelId, String endpoint) {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.serviceRegistry.getService(TunnelConfiguration.class);
        DirectTunnelClient directClient = new DirectTunnelClient(this.tunnelEndpoint, this.clientId, this.connectivityContext);
        ForwardingTunnelConnectionAttributesRetriever retriever = new ForwardingTunnelConnectionAttributesRetriever(tunnelId, endpoint, (ConnectivityContext)this.notificationConnectivityContext, tunnelConfiguration);
        return new ManagedForwardingTunnelImpl(directClient, retriever, this.connectivityContext, endpoint);
    }

    public ForwardingTunnel createRFCForwardingTunnel(String tunnelId, String tunnelServerHost, int tunnelPort) {
        TunnelEndpointS4HANA endpoint = new TunnelEndpointS4HANA(this.tunnelEndpoint, tunnelServerHost, tunnelPort);
        String path = "/connectivity?sap-connagent=CONNAGENT_LB";
        DirectTunnelClient directClient = new DirectTunnelClient(endpoint, this.clientId, this.connectivityContext);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(Integer.valueOf("0"), "abapVirtualHost");
        ForwardingTunnelConnectionAttributes.MappingEntries mappings = new ForwardingTunnelConnectionAttributes.MappingEntries(map);
        String s4InstanceEndpoint = "rfc:///" + tunnelServerHost;
        ForwardingTunnelConnectionAttributes connectionAttributes = this.generateDirectForwardingTunnelConnectionAttributes(tunnelServerHost, tunnelId, s4InstanceEndpoint, path, mappings);
        return new ForwardingTunnelImpl(directClient, this.connectivityContext, s4InstanceEndpoint, connectionAttributes);
    }

    public List<DBSystemInformation> getAvailableDBSystems(String tunnelId) throws ConnectionFailedException {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.serviceRegistry.getService(TunnelConfiguration.class);
        try {
            return new AvailableSystemsInfoRetriever((ConnectivityContext)this.notificationConnectivityContext, tunnelConfiguration).retrieveDBSystems(tunnelId);
        }
        catch (NoChannelsAvailableException e) {
            throw new ConnectionFailedException("Internal error", (Throwable)e);
        }
    }

    public List<HCPVMInformation> getAvailableHCPVMs(String tunnelId) throws ConnectionFailedException {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.serviceRegistry.getService(TunnelConfiguration.class);
        try {
            return new AvailableSystemsInfoRetriever((ConnectivityContext)this.notificationConnectivityContext, tunnelConfiguration).retrieveHCPVMs(tunnelId);
        }
        catch (NoChannelsAvailableException e) {
            throw new ConnectionFailedException("Internal error", (Throwable)e);
        }
    }

    private MeteringDataSender createMeteringDataSender() {
        DefaultMeteringMessagePacketFactory meteringMessagePacketFactory = new DefaultMeteringMessagePacketFactory((MessagePacketFactory)new MessagePacketFactoryImpl());
        MeteringDataProvider meteringDataProvider = (MeteringDataProvider)this.serviceRegistry.getOptionalService(MeteringDataProvider.class);
        MeteringMessagesProvider meteringMessagesProvider = (MeteringMessagesProvider)this.serviceRegistry.getOptionalService(MeteringMessagesProvider.class);
        TunnelRegistry tunnelRegistry = this.notificationConnectivityContext.getTunnelRegistry();
        return new MeteringDataSender((MeteringMessagePacketFactory)meteringMessagePacketFactory, meteringDataProvider, meteringMessagesProvider, tunnelRegistry);
    }

    private ForwardingTunnelConnectionAttributes generateDirectForwardingTunnelConnectionAttributes(String cloudLandscapeDomain, String tunnelId, String fwTunnelEndpoint, String path, ForwardingTunnelConnectionAttributes.MappingEntries mappings) {
        TunnelIdParser parser = new TunnelIdParser();
        try {
            TunnelIdModel tunnelIdModel = parser.parse(tunnelId);
            ForwardingTunnelEndpointModel endpointModel = ForwardingTunnelEndpointParser.parse((String)fwTunnelEndpoint);
            ProxyProtocol protocol = endpointModel.getProtocol();
            String fwTunnelId = ForwardingTunnelIdFactory.createTunnelId((String)tunnelIdModel.getLocation(), (String)cloudLandscapeDomain, (ForwardingTunnelType)ForwardingTunnelType.fromProxyProtocol((ProxyProtocol)protocol), (String)tunnelIdModel.getAccount(), (String)endpointModel.getInstance());
            RoutingInformation routingInfo = new RoutingInformation(tunnelIdModel.getAccount(), CONNAGENT_LB, null, path);
            return new ForwardingTunnelConnectionAttributes(routingInfo, fwTunnelId, mappings, protocol);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Could not parse the passed tunnel ID [%s]", tunnelId));
        }
    }
}

