/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.notification;

import com.google.gson.Gson;
import com.sap.core.connectivity.onpremise.OnPremiseInformation;
import com.sap.core.connectivity.onpremise.OnPremiseInformationChangedEvent;
import com.sap.core.connectivity.onpremise.OnPremiseInformationListener;
import com.sap.core.connectivity.onpremise.OnPremiseInformationProvider;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.tunnel.api.management.HTTPSProxy;
import com.sap.core.connectivity.tunnel.api.management.NotificationTunnelInformation;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperatorEvent;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperatorListener;
import com.sap.core.connectivity.tunnel.client.AbstractClient;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelClient;
import com.sap.core.connectivity.tunnel.client.NotificationClientHandshaker;
import com.sap.core.connectivity.tunnel.client.handshake.TunnelClientHandshakeFuture;
import com.sap.core.connectivity.tunnel.client.notification.NotificationClientChannelInitializer;
import com.sap.core.connectivity.tunnel.client.notification.NotificationClientConnectPromise;
import com.sap.core.connectivity.tunnel.client.notification.NotificationClientConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.notification.NotificationClientEventHandler;
import com.sap.core.connectivity.tunnel.client.notification.NotificationConnectivityContext;
import com.sap.core.connectivity.tunnel.client.notification.NotificationTunnelInformationImpl;
import com.sap.core.connectivity.tunnel.client.reconnect.MaxReconnectAttemptsExceededException;
import com.sap.core.connectivity.tunnel.client.reconnect.ReconnectScheduler;
import com.sap.core.connectivity.tunnel.client.reconnect.Reconnectable;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.log4j.Logger;

public class NotificationClient
extends AbstractClient<NotificationClientConnectionAttributes>
implements Reconnectable {
    private static final Logger log = Logger.getLogger(NotificationClient.class);
    private static final String RECONNECT_HANDLER_NAME = "reconnectHandler";
    private NotificationClientConnectPromise connectPromise;
    private final Set<String> managedTunnelIds = new HashSet<String>();
    private final ManagedTunnelClient tunnelClient;
    private final NotificationConnectivityContext notificationContext;
    private final NotificationClientEventHandler notificationEventHandler;
    private final NotificationTunnelInformationImpl notificationTunnelInfo = new NotificationTunnelInformationImpl();
    private final ReconnectScheduler reconnectScheduler;
    private InetSocketAddress unresolvedTunnelServerAddress;
    private OnPremiseInformationProvider onPremiseInfoProvider;
    private OnPremiseInformationListener onPremiseListener;
    private final Gson gson = new Gson();

    public NotificationClient(TunnelEndpoint endpoint, String clientId, ManagedTunnelClient tunnelClient, NotificationConnectivityContext notificationConnectivityContext) {
        super(endpoint, clientId);
        this.tunnelClient = tunnelClient;
        this.notificationContext = notificationConnectivityContext;
        this.notificationEventHandler = new NotificationClientEventHandler(tunnelClient, clientId, (ConnectivityContext)this.notificationContext);
        this.notificationEventHandler.addListener(new SubscriptionsUpdateListener());
        this.reconnectScheduler = new ReconnectScheduler(this, this.configuration.getClientMaxReconnectAttempts(), this.configuration.getClientInitialReconnectDelay());
    }

    @Override
    protected String getName() {
        return "notification-client";
    }

    public void subscribeTunnels(Collection<String> tunnelIds) {
        this.subscribeTunnels(tunnelIds, true);
    }

    @Override
    public void reconnect() {
        if (this.notificationTunnelInfo.getState() != NotificationTunnelInformation.State.RECONNECTING) {
            log.debug((Object)String.format("Skipping reconnect for {0} because state has changed to {1}", this.managedTunnelIds, this.notificationTunnelInfo.getState()));
            return;
        }
        this.subscribeTunnels(this.managedTunnelIds, false);
    }

    @Override
    public String getDescription() {
        return this.endpoint.getNotificationAddress().toString();
    }

    private void subscribeTunnels(final Collection<String> tunnelIds, boolean isInitialConnect) {
        if (tunnelIds.isEmpty()) {
            throw new IllegalArgumentException("Supplied list of tunnel identifiers cannot be empty");
        }
        this.connectPromise = this.connectIfNeeded(tunnelIds, isInitialConnect);
        this.connectPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NotificationClient.this.sendSubscribeEvent(tunnelIds);
                    NotificationClient.this.registerOnpremiseInfoListener(NotificationClient.this.connectPromise.channel());
                    NotificationClient.this.sendUpdateOnPremiseInfoEvent(tunnelIds);
                }
            }
        });
    }

    private void sendSubscribeEvent(Collection<String> tunnelIds) {
        for (String tunnelId : tunnelIds) {
            MessagePacket packet = this.notificationContext.getMessagePacketFactory().createMessagePacket("notification", 2);
            packet.setProperty("clientId", this.clientId);
            packet.setProperty("tunnelId", tunnelId);
            Channel channel = this.connectPromise.channel();
            ChannelFuture future = channel.writeAndFlush((Object)packet);
            future.addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)MessageFormat.format("Sent \"subscribe request\" message (packet type: {0}) for tunnel id \"{1}\" and client id \"{2}\" over notification tunnel channel {3}", 2, tunnelId, this.clientId, channel));
        }
    }

    private void registerOnpremiseInfoListener(Channel channel) {
        this.onPremiseListener = new DefaultOnPremiseInformationListener(this.connectPromise.channel());
        this.getOnPremiseInfoProvider().addListener(this.onPremiseListener);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NotificationClient.this.getOnPremiseInfoProvider().removeListener(NotificationClient.this.onPremiseListener);
            }
        });
    }

    private void sendUpdateOnPremiseInfoEvent(Collection<String> tunnelIds) {
        for (String tunnelId : tunnelIds) {
            OnPremiseInformation information = this.getOnPremiseInfoProvider().getOnPremiseInformation(tunnelId);
            this.sendOnPremiseInfo(tunnelId, information, this.connectPromise.channel());
        }
    }

    private void sendOnPremiseInfo(String tunnelId, OnPremiseInformation information, Channel channel) {
        String json = this.gson.toJson((Object)information);
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])json.getBytes(Charset.forName("UTF-8")));
        PayloadMessagePacket packet = this.notificationContext.getMessagePacketFactory().createPayloadPacket("notification", 8, payload);
        packet.setProperty("tunnelId", tunnelId);
        ChannelFuture future = channel.writeAndFlush((Object)packet);
        future.addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Sent \"update onpremise info\" message (packet type: {0}) for tunnel id \"{1}\" over notification tunnel channel {2}", 8, tunnelId, channel));
        }
    }

    public void unsubscribeTunnels(final List<String> tunnelIds) {
        if (tunnelIds.isEmpty()) {
            throw new IllegalArgumentException("Supplied list of tunnel identifiers cannot be empty");
        }
        if (this.connectPromise == null || !this.connectPromise.isSuccess()) {
            throw new IllegalStateException("Notification tunnel is not connected so events cannot be sent");
        }
        this.connectPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NotificationClient.this.sendUnsubscribeEvent(tunnelIds);
                    NotificationClient.this.sendRemoveOnPremiseInfoEvent(tunnelIds);
                }
            }
        });
    }

    private void sendUnsubscribeEvent(List<String> tunnelIds) {
        for (String tunnelId : tunnelIds) {
            MessagePacket packet = this.notificationContext.getMessagePacketFactory().createMessagePacket("notification", 3);
            packet.setProperty("tunnelId", tunnelId);
            Channel notificationTunnelChannel = this.connectPromise.channel();
            notificationTunnelChannel.writeAndFlush((Object)packet).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)MessageFormat.format("Sent \"unsubscribe request\" message (packet type: {0}) for tunnel id \"{1}\" and client id \"{2}\" over notification tunnel channel {3}", 3, tunnelId, this.clientId, notificationTunnelChannel));
        }
    }

    private void sendRemoveOnPremiseInfoEvent(Collection<String> tunnelIds) {
        for (String tunnelId : tunnelIds) {
            MessagePacket packet = this.notificationContext.getMessagePacketFactory().createMessagePacket("notification", 9);
            packet.setProperty("tunnelId", tunnelId);
            Channel channel = this.connectPromise.channel();
            channel.writeAndFlush((Object)packet).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)MessageFormat.format("Sent \"remove onpremise info\" message (packet type: {0}) for tunnel id \"{1}\" over notification tunnel channel {2}", 9, tunnelId, channel));
        }
    }

    private NotificationClientConnectPromise connectIfNeeded(Collection<String> tunnelIds, boolean isInitialConnect) {
        if (this.connectPromise == null || !this.connectPromise.channel().isActive()) {
            this.connectUsingNextTunnelId(tunnelIds.iterator(), isInitialConnect, true);
        }
        return this.connectPromise;
    }

    private void connectUsingNextTunnelId(Iterator<String> tunnelIdsIterator, boolean isInitialConnect, boolean isNewPromiseNeeded) {
        String tunnelId = tunnelIdsIterator.next();
        this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.CONNECTING);
        TunnelClientHandshakeFuture channelFuture = this.doConnect(new NotificationClientConnectionAttributes(tunnelId, this.unresolvedTunnelServerAddress));
        if (isNewPromiseNeeded) {
            this.connectPromise = new NotificationClientConnectPromise(channelFuture.channel());
        } else {
            this.connectPromise.setChannel(channelFuture.channel());
        }
        channelFuture.addListener((GenericFutureListener)new HandshakeListener(tunnelId, tunnelIdsIterator, isInitialConnect));
    }

    @Override
    protected ChannelInitializer<?> createChannelInitializer(NotificationClientConnectionAttributes attributes) {
        NotificationClientHandshaker notificationClientHandshaker = new NotificationClientHandshaker((ConnectivityContext)this.notificationContext, attributes.getTunnelId(), this.endpoint, this.clientId, this.endpoint.getNotificationAddress(), this.getProxy());
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.notificationContext.getServiceRegistry().getService(TunnelConfiguration.class);
        return new NotificationClientChannelInitializer((ConnectivityContext)this.notificationContext, attributes.getTunnelId(), notificationClientHandshaker, tunnelConfiguration.getNotificationClientIdleTime(), this.notificationEventHandler);
    }

    @Override
    protected InetSocketAddress getServerAddress() {
        return this.endpoint.getNotificationAddress();
    }

    @Override
    protected HTTPSProxy getProxy() {
        return this.endpoint.getHttpsProxy();
    }

    NotificationTunnelInformationImpl getNotificationInfo() {
        return this.notificationTunnelInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            try {
                if (this.connectPromise != null && this.connectPromise.channel().pipeline().get(RECONNECT_HANDLER_NAME) != null) {
                    this.connectPromise.channel().pipeline().remove(RECONNECT_HANDLER_NAME);
                }
                this.reconnectScheduler.reset();
                this.connectPromise = null;
                this.managedTunnelIds.clear();
                super.doDisconnect();
            }
            finally {
                this.tunnelClient.disconnect();
            }
        }
        finally {
            this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.DISCONNECTED);
        }
    }

    public void addListener(TunnelOperatorListener listener) {
        this.notificationEventHandler.addListener(listener);
    }

    public void removeListener(TunnelOperatorListener listener) {
        this.notificationEventHandler.removeListener(listener);
    }

    public NotificationTunnelInformation getNotificationTunnelInfo() {
        return this.notificationTunnelInfo;
    }

    void disconnectiNotificationClientChannels() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                NotificationClient.this.doDisconnect();
            }
        });
        t.start();
    }

    private OnPremiseInformationProvider getOnPremiseInfoProvider() {
        if (this.onPremiseInfoProvider == null) {
            this.onPremiseInfoProvider = (OnPremiseInformationProvider)this.notificationContext.getServiceRegistry().getService(OnPremiseInformationProvider.class);
        }
        return this.onPremiseInfoProvider;
    }

    private class DefaultOnPremiseInformationListener
    implements OnPremiseInformationListener {
        private final Channel channel;

        public DefaultOnPremiseInformationListener(Channel channel) {
            this.channel = channel;
        }

        public void onPremiseInformationChanged(OnPremiseInformationChangedEvent event) {
            OnPremiseInformation information = event.getOnPremiseInformation();
            String tunnelId = event.getTunnelId();
            NotificationClient.this.sendOnPremiseInfo(tunnelId, information, this.channel);
        }
    }

    class HandshakeListener
    implements ChannelFutureListener {
        private final String tunnelId;
        private final Iterator<String> tunnelIdsIterator;
        private final boolean isInitialConnect;

        HandshakeListener(String tunnelId, Iterator<String> tunnelIdsIterator, boolean isInitialConnect) {
            this.tunnelId = tunnelId;
            this.tunnelIdsIterator = tunnelIdsIterator;
            this.isInitialConnect = isInitialConnect;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            Channel channel = future.channel();
            if (future.isSuccess()) {
                this.handleHandshakeSucceeded(channel);
                log.info((Object)("Successfully established tunnel channel to notification service: " + channel));
                channel.config().setAutoRead(true);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Enabled reading from channel %s for tunnel ID: %s", channel, this.tunnelId));
                }
            } else {
                log.error((Object)("Unable to handshake with notification server " + NotificationClient.this.endpoint.getNotificationAddress()), future.cause());
                this.handleHandshakeFailed(future);
            }
        }

        private void handleHandshakeSucceeded(Channel channel) throws TunnelRegistrationException {
            NotificationClient.this.notificationContext.getTunnelRegistry().registerTunnelChannel(this.tunnelId, NotificationClient.this.clientId, channel);
            NotificationClient.this.reconnectScheduler.reset();
            this.attachReconnectHandler(channel);
            NotificationClient.this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.CONNECTED);
            NotificationClient.this.connectPromise.setSuccess();
        }

        private void attachReconnectHandler(Channel channel) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding reconnection handler in the pipeline");
            }
            channel.pipeline().addLast(NotificationClient.RECONNECT_HANDLER_NAME, (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    HandshakeListener.this.scheduleReconnectAttempt();
                    super.channelInactive(ctx);
                }
            });
        }

        private void handleHandshakeFailed(ChannelFuture future) throws Exception {
            if (this.isInitialConnect) {
                if (!this.tunnelIdsIterator.hasNext() || future.cause() instanceof SocketException) {
                    NotificationClient.this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.CONNECT_FAILED, future.cause());
                    NotificationClient.this.connectPromise.setFailure(future.cause());
                    NotificationClient.this.disconnectiNotificationClientChannels();
                } else {
                    NotificationClient.this.connectUsingNextTunnelId(this.tunnelIdsIterator, true, false);
                }
            } else {
                if (this.isPossibleRemoteIpChange(future)) {
                    InetSocketAddress notificationTunnelServer = NotificationClient.this.endpoint.getNotificationAddress();
                    NotificationClient.this.unresolvedTunnelServerAddress = InetSocketAddress.createUnresolved(notificationTunnelServer.getHostName(), notificationTunnelServer.getPort());
                } else {
                    NotificationClient.this.unresolvedTunnelServerAddress = null;
                }
                this.scheduleReconnectAttempt();
            }
        }

        private boolean isPossibleRemoteIpChange(ChannelFuture future) {
            return future.cause() instanceof SSLException;
        }

        private void scheduleReconnectAttempt() {
            try {
                NotificationClient.this.reconnectScheduler.schedule();
                NotificationClient.this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.RECONNECTING);
            }
            catch (MaxReconnectAttemptsExceededException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                } else {
                    log.error((Object)String.format("%s: %s", e.getClass().getSimpleName(), e.getMessage()));
                }
                NotificationClient.this.notificationTunnelInfo.updateState(NotificationTunnelInformation.State.RECONNECT_FAILED);
            }
        }
    }

    private class SubscriptionsUpdateListener
    implements TunnelOperatorListener {
        private SubscriptionsUpdateListener() {
        }

        public void operationComplete(TunnelOperatorEvent event) {
            switch (event.getOperationType()) {
                case TUNNEL_ENABLED: {
                    this.handleTunnelEnabled(event);
                    break;
                }
                case TUNNEL_DISABLED: {
                    this.handleTunnelDisabled(event);
                }
            }
        }

        private void handleTunnelEnabled(TunnelOperatorEvent event) {
            String tunnelId = event.getTunnelId();
            if (event.isSuccessful()) {
                NotificationClient.this.managedTunnelIds.add(tunnelId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("Successfully subscribed for events for tunnel id \"{0}\" and client id \"{1}\"", tunnelId, NotificationClient.this.clientId));
                }
            } else {
                log.error((Object)MessageFormat.format("Unabled to subscribe for events for tunnel id \"{0}\" and client id \"{1}\", reason: {2}", tunnelId, NotificationClient.this.clientId, event.getErrorMessage()));
            }
        }

        private void handleTunnelDisabled(TunnelOperatorEvent event) {
            String tunnelId = event.getTunnelId();
            NotificationClient.this.managedTunnelIds.remove(tunnelId);
            if (NotificationClient.this.managedTunnelIds.isEmpty()) {
                NotificationClient.this.disconnect();
            } else {
                NotificationClient.this.tunnelClient.disconnect(tunnelId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("Successfully unsubscribed for events for tunnel id \"{0}\" and client id \"{1}\"", tunnelId, NotificationClient.this.clientId));
            }
        }
    }
}

