/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.notification;

import com.google.gson.Gson;
import com.sap.core.connectivity.onpremise.ConnectivityCACertificateInfo;
import com.sap.core.connectivity.onpremise.OnPremiseOperationStatus;
import com.sap.core.connectivity.onpremise.OnPremiseOperator;
import com.sap.core.connectivity.onpremise.validator.OnPremiseEndpointState;
import com.sap.core.connectivity.onpremise.validator.OnPremiseEndpointValidationException;
import com.sap.core.connectivity.onpremise.validator.OnPremiseEndpointValidator;
import com.sap.core.connectivity.onpremise.validator.OnPremiseEndpointValidatorProvider;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.tunnel.api.LookupException;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.dr.DisasterRecovery;
import com.sap.core.connectivity.tunnel.api.dr.DisasterRecoveryException;
import com.sap.core.connectivity.tunnel.api.management.ApplicationTunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperatorEvent;
import com.sap.core.connectivity.tunnel.api.management.TunnelOperatorListener;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelClient;
import com.sap.core.connectivity.tunnel.client.ManagedTunnelConnectionAttributes;
import com.sap.core.connectivity.tunnel.client.TunnelAttributesImpl;
import com.sap.core.connectivity.tunnel.client.TunnelNotAllowedException;
import com.sap.core.connectivity.tunnel.client.management.TunnelOperatorEventImpl;
import com.sap.core.connectivity.tunnel.client.notification.BackendStatus;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import com.sap.core.connectivity.tunnel.core.dr.DisasterRecoveryResponse;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeException;
import com.sap.core.connectivity.tunnel.core.processing.AbstractEventHandler;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import com.sap.core.connectivity.tunnel.core.routing.RoutingInformation;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;

@ChannelHandler.Sharable
class NotificationClientEventHandler
extends AbstractEventHandler {
    private static final Logger log = Logger.getLogger(NotificationClientEventHandler.class);
    private static final String DELIMITER_SEMICOLON = ";";
    private static final String DELIMITER_COLON = ":";
    private final ManagedTunnelClient tunnelClient;
    private final String clientId;
    private final List<TunnelOperatorListener> listeners = new ArrayList<TunnelOperatorListener>();
    private final Gson gson = new Gson();
    private final TunnelIdParser idParser = new TunnelIdParser();
    private OnPremiseOperator onPremiseOperator;

    public NotificationClientEventHandler(ManagedTunnelClient tunnelClient, String clientId, ConnectivityContext context) {
        super(context);
        this.tunnelClient = tunnelClient;
        this.clientId = clientId;
    }

    public OnPremiseOperator getSCCOperator() {
        if (this.onPremiseOperator == null) {
            this.onPremiseOperator = (OnPremiseOperator)this.context.getServiceRegistry().getService(OnPremiseOperator.class);
        }
        return this.onPremiseOperator;
    }

    protected boolean acceptsPacket(MessagePacket packet) {
        if (!"notification".equals(packet.getOwner())) {
            return false;
        }
        switch (packet.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        log.trace((Object)("Unknown packet type: " + packet.getType()));
        return false;
    }

    protected void processPacket(MessagePacket packet, Channel channel) {
        switch (packet.getType()) {
            case 1: {
                this.openTunnel(packet);
                break;
            }
            case 4: {
                this.tunnelEnabled(packet, channel);
                break;
            }
            case 5: {
                this.tunnelDisabled(packet, channel);
                break;
            }
            case 10: {
                this.checkBackendStatus(packet, channel);
                break;
            }
            case 12: {
                this.disconnectSCCAccount(packet, channel);
                break;
            }
            case 14: {
                this.triggerDisasterRecovery(packet, channel);
                break;
            }
            case 15: {
                this.triggerDisasterRecovery(packet, channel);
                break;
            }
            case 16: {
                this.handleCaExpiringCert(packet);
                break;
            }
            default: {
                log.trace((Object)("Unknown packet type: " + packet.getType()));
            }
        }
    }

    public void addListener(TunnelOperatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TunnelOperatorListener listener) {
        this.listeners.remove(listener);
    }

    private void openTunnel(MessagePacket packet) {
        String tunnelId = packet.getProperty("tunnelId");
        String poolName = packet.getProperty("poolName");
        String hostIdentifier = packet.getProperty("hostIdentifier");
        String fingerprint = packet.getProperty("vmCertificateFingerprint");
        String path = packet.getProperty("path");
        String providerApplication = packet.getProperty("providerApplication");
        String providerAccount = packet.getProperty("providerAccount");
        String providerApplicationType = packet.getProperty("providerApplicationType");
        String tunnelServerHost = packet.getProperty("s4hanaHost");
        String tunnelServerPort = packet.getProperty("s4hanaPort");
        RoutingInformation routingInformation = new RoutingInformation(poolName, hostIdentifier, fingerprint, path);
        log.info((Object)MessageFormat.format("Received \"open tunnel event\" message (packet type: {0}) for tunnel id {1} and hostId {2}", packet.getType(), tunnelId, hostIdentifier));
        TunnelAttributesImpl attributes = new TunnelAttributesImpl();
        attributes.setAttribute("applicationName", providerApplication);
        attributes.setAttribute("applicationAccount", providerAccount);
        attributes.setAttribute("applicationType", providerApplicationType);
        int connectionCount = this.getTunnelConnectionCount(tunnelId, providerAccount, providerApplication);
        ManagedTunnelConnectionAttributes connectionAttributes = null;
        if (this.isTunnelToS4HANA(tunnelServerHost, tunnelServerPort)) {
            InetSocketAddress tunnelServerAddress = new InetSocketAddress(tunnelServerHost, (int)Integer.valueOf(tunnelServerPort));
            connectionAttributes = new ManagedTunnelConnectionAttributes(tunnelId, routingInformation, attributes, connectionCount, tunnelServerAddress);
            log.info((Object)MessageFormat.format("Opening a tunnel to S4HANA System {0}:{1}", tunnelServerHost, tunnelServerPort));
        } else {
            connectionAttributes = new ManagedTunnelConnectionAttributes(tunnelId, routingInformation, attributes, connectionCount);
        }
        Thread tunnelConnectionThread = new Thread(new TunnelConnectionRunnable(connectionAttributes));
        tunnelConnectionThread.start();
    }

    private int getDefaultTunnelConnectionCount() {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
        return tunnelConfiguration.getClientNumberChannel();
    }

    private int getTunnelConnectionCount(String tunnelId, String providerAccount, String providerApplication) {
        if (!this.isEmpty(providerAccount) && !this.isEmpty(providerApplication)) {
            try {
                ApplicationTunnelConfiguration applicationConfiguration = (ApplicationTunnelConfiguration)this.context.getServiceRegistry().getService(ApplicationTunnelConfiguration.class);
                if (applicationConfiguration != null) {
                    return applicationConfiguration.getConnectionCount(tunnelId, providerAccount, providerApplication);
                }
                log.warn((Object)"No ApplicationTunnelConfiguration registered. Will use the default channel configuration.");
            }
            catch (LookupException ex) {
                log.warn((Object)"Will use the default channel configuration because of: ", (Throwable)ex);
            }
        }
        return this.getDefaultTunnelConnectionCount();
    }

    private boolean isEmpty(String data) {
        return data == null || data.isEmpty();
    }

    private boolean isTunnelToS4HANA(String tunnelServerHost, String tunnelServerPort) {
        return tunnelServerHost != null && !tunnelServerHost.isEmpty() && tunnelServerPort != null && !tunnelServerPort.isEmpty();
    }

    private void tunnelEnabled(MessagePacket packet, Channel channel) {
        String tunnelId = packet.getProperty("tunnelId");
        String errorMessage = packet.getProperty("message");
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Received \"tunnel enabled response\" message (packet type: {0}) for tunnel id \"{1}\"", packet.getType(), tunnelId));
        }
        try {
            if (errorMessage == null) {
                this.context.getTunnelRegistry().registerTunnelChannel(tunnelId, this.clientId, channel);
            }
            this.fireEvent(channel.eventLoop(), new TunnelOperatorEventImpl(TunnelOperatorEvent.OperationType.TUNNEL_ENABLED, tunnelId, errorMessage));
        }
        catch (TunnelRegistrationException e) {
            log.error((Object)MessageFormat.format("Unable to register tunnel channel {0} for tunnel id \"{1}\"", channel, tunnelId), (Throwable)e);
        }
    }

    private void tunnelDisabled(MessagePacket packet, Channel channel) {
        String tunnelId = packet.getProperty("tunnelId");
        String errorMessage = packet.getProperty("message");
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Received tunnel disabled response for tunnel id \"{0}\"", tunnelId));
        }
        this.context.getTunnelRegistry().unregisterTunnelChannel(tunnelId, channel);
        this.fireEvent(channel.eventLoop(), new TunnelOperatorEventImpl(TunnelOperatorEvent.OperationType.TUNNEL_DISABLED, tunnelId, errorMessage));
    }

    private void fireEvent(EventLoop eventLoop, TunnelOperatorEvent event) {
        eventLoop.execute((Runnable)new TunnelEventFiringRunnable(event));
    }

    private void checkBackendStatus(MessagePacket packet, Channel channel) {
        String tunnelId = packet.getProperty("tunnelId");
        String connectionId = packet.getProperty("connectionId");
        String host = packet.getProperty("backendHost");
        String port = packet.getProperty("backendPort");
        String resource = packet.getProperty("backendResource");
        BackendStatus backendStatus = BackendStatus.UNKNOWN;
        try {
            OnPremiseEndpointState endpointState = this.checkEndpoint(tunnelId, host, port, resource);
            backendStatus = this.convertToBackendStatus(endpointState);
        }
        catch (Exception e) {
            log.error((Object)MessageFormat.format("Unexpected exception while checking the endpoint \"{0}:{1}/{2}\" for tunnel \"{3}\"", host, port, resource, tunnelId), (Throwable)e);
        }
        this.sendBackendStatusResponsePacket(tunnelId, connectionId, backendStatus, channel);
    }

    private OnPremiseEndpointState checkEndpoint(String tunnelId, String host, String port, String resource) throws OnPremiseEndpointValidationException {
        OnPremiseEndpointValidatorProvider endpointValidatorProvider = (OnPremiseEndpointValidatorProvider)this.context.getServiceRegistry().getService(OnPremiseEndpointValidatorProvider.class);
        OnPremiseEndpointValidator endpointValidator = endpointValidatorProvider.getEndpointValidator(tunnelId);
        if (endpointValidator == null) {
            throw new OnPremiseEndpointValidationException("Endpoint cannot be checked. No endpoint validators are registered.", null);
        }
        return endpointValidator.checkEndpoint(host, port, resource);
    }

    private BackendStatus convertToBackendStatus(OnPremiseEndpointState endpointState) {
        if (endpointState != null) {
            switch (endpointState) {
                case ENDPOINT_NOT_CONFIGURED: {
                    return BackendStatus.NOT_CONFIGURED;
                }
                case ENDPOINT_CONFIGURED: {
                    return BackendStatus.CONFIGURED;
                }
                case RESOURCE_ACCESSIBLE: {
                    return BackendStatus.RESOURCE_CONFIGURED;
                }
                case ENDPOINT_REACHABLE: {
                    return BackendStatus.ACCESSIBLE;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("The endpoint state \"{0}\" could not be converted to a backend status and BackendStatus.UNKNOWN is returned", endpointState));
        }
        return BackendStatus.UNKNOWN;
    }

    private void sendBackendStatusResponsePacket(String tunnelId, String connectionId, BackendStatus backendStatus, Channel channel) {
        String response = this.gson.toJson((Object)backendStatus);
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])response.getBytes(Charset.forName("UTF-8")));
        PayloadMessagePacket packet = this.context.getMessagePacketFactory().createPayloadPacket("notification", 11, payload);
        packet.setProperty("tunnelId", tunnelId);
        packet.setProperty("connectionId", connectionId);
        channel.writeAndFlush((Object)packet).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Send backend status response {0} for tunnel id \"{1}\" and connectionId \"{2}\"", response, tunnelId, connectionId));
        }
    }

    private void disconnectSCCAccount(MessagePacket packet, Channel channel) {
        String tunnelId = packet.getProperty("tunnelId");
        String userId = packet.getProperty("userId");
        String connectionId = packet.getProperty("connectionId");
        OnPremiseOperationStatus onPremiseOperationStatus = new OnPremiseOperationStatus();
        try {
            String account = this.idParser.parse(tunnelId).getAccount();
            onPremiseOperationStatus = this.getSCCOperator().disconnectAccount(account, userId);
        }
        catch (Exception e) {
            log.error((Object)String.format("Unable to disconnect scc tunnel: %s by user: %s", tunnelId, userId), (Throwable)e);
            onPremiseOperationStatus.addAttribute("status", "connected");
            onPremiseOperationStatus.addAttribute("message", e.getMessage());
        }
        if (!"disconnected".equals(onPremiseOperationStatus.getAttribute("status"))) {
            this.sendDisconnectStatusResponse(connectionId, onPremiseOperationStatus, channel);
        }
    }

    private void sendDisconnectStatusResponse(String connectionId, OnPremiseOperationStatus onPremiseOperationStatus, Channel channel) {
        String response = this.gson.toJson((Object)onPremiseOperationStatus);
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])response.getBytes(Charset.forName("UTF-8")));
        PayloadMessagePacket messagePacket = this.context.getMessagePacketFactory().createPayloadPacket("notification", 12, payload);
        messagePacket.setProperty("connectionId", connectionId);
        if (channel.isOpen()) {
            channel.writeAndFlush((Object)messagePacket).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
        }
    }

    private void handleCaExpiringCert(MessagePacket packet) {
        String[] expiringCaInfos;
        ArrayList<ConnectivityCACertificateInfo> expiringCertsInfoList = new ArrayList<ConnectivityCACertificateInfo>();
        String expiringCaInfoProperty = packet.getProperty("expiringConnectivityCa");
        for (String expiringCaInfo : expiringCaInfos = expiringCaInfoProperty.split(DELIMITER_SEMICOLON)) {
            String[] caCertInfo = expiringCaInfo.trim().split(DELIMITER_COLON);
            String serialNumber = caCertInfo[0];
            String subjectDN = caCertInfo[1];
            long expirationTime = Long.parseLong(caCertInfo[2]);
            TimeZone timeZone = TimeZone.getTimeZone(caCertInfo[3]);
            expiringCertsInfoList.add(new ConnectivityCACertificateInfo(serialNumber, subjectDN, expirationTime, timeZone));
        }
        this.getSCCOperator().caCertsAboutToExpire(expiringCertsInfoList);
    }

    private void triggerDisasterRecovery(MessagePacket requestPacket, Channel channel) {
        String tunnelId = requestPacket.getProperty("tunnelId");
        String requestId = requestPacket.getProperty("requestId");
        DisasterRecoveryResponse drResponse = this.getDisasterRecoveryResponse(requestPacket.getType(), tunnelId);
        byte[] payloadBytes = this.gson.toJson((Object)drResponse).getBytes(StandardCharsets.UTF_8);
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])payloadBytes);
        PayloadMessagePacket responsePacket = this.context.getMessagePacketFactory().createResponsePacket(requestPacket, payload);
        responsePacket.setProperty("tunnelId", tunnelId);
        channel.writeAndFlush((Object)responsePacket).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Send disaster recovery response {0} for request type {1}, tunnel id \"{2}\" and requestId \"{3}\" over tunnel channel {4} ", drResponse.status(), requestPacket.getType(), tunnelId, requestId, channel));
        }
    }

    private DisasterRecoveryResponse getDisasterRecoveryResponse(int requestType, String tunnelId) {
        DisasterRecovery disasterRecovery = (DisasterRecovery)this.context.getServiceRegistry().getService(DisasterRecovery.class);
        DisasterRecoveryResponse drResponse = null;
        try {
            switch (requestType) {
                case 14: {
                    disasterRecovery.enable(tunnelId);
                    break;
                }
                case 15: {
                    disasterRecovery.disable(tunnelId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format("Unknown disaster recovery request type {0}", requestType));
                }
            }
            drResponse = new DisasterRecoveryResponse(DisasterRecoveryResponse.Status.SUCCESS);
        }
        catch (DisasterRecoveryException e) {
            log.debug((Object)"Disaster Recovery exception", (Throwable)e);
            drResponse = new DisasterRecoveryResponse(DisasterRecoveryResponse.Status.FAILURE, e.getMessage());
        }
        return drResponse;
    }

    class TunnelConnectionRunnable
    implements Runnable {
        private final ManagedTunnelConnectionAttributes attributes;

        public TunnelConnectionRunnable(ManagedTunnelConnectionAttributes attributes) {
            this.attributes = attributes;
        }

        @Override
        public void run() {
            block4: {
                try {
                    NotificationClientEventHandler.this.tunnelClient.connect(this.attributes);
                }
                catch (TunnelNotAllowedException e) {
                    log.error((Object)e.getMessage());
                }
                catch (TunnelHandshakeException e) {
                    log.error((Object)("Unable to open tunnel connection: " + e.getMessage()));
                }
                catch (Exception e) {
                    log.error((Object)("Unexpected exception while establishing tunnel connection for tunnel: " + this.attributes.getTunnelId()), (Throwable)e);
                    if ($assertionsDisabled || AssertionUtil.propagateException((Throwable)e)) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    class TunnelEventFiringRunnable
    implements Runnable {
        private TunnelOperatorEvent event;

        private TunnelEventFiringRunnable(TunnelOperatorEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (TunnelOperatorListener listener : NotificationClientEventHandler.this.listeners) {
                try {
                    listener.operationComplete(this.event);
                }
                catch (Exception e) {
                    log.error((Object)"Exception while notifying tunnel operator listener", (Throwable)e);
                }
            }
        }
    }
}

