/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.notification;

import com.sap.core.connectivity.spi.protocol.MessagePacketFactory;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.DefaultConnectivityContext;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelChannelUnregisteredEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryListener;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryListenerAdapter;
import com.sap.core.connectivity.tunnel.core.impl.processing.ResponsePacketProcessor;
import com.sap.core.connectivity.tunnel.metering.DefaultMeteringMessagePacketFactory;
import com.sap.core.connectivity.tunnel.metering.MeteringMessagePacketFactory;
import com.sap.core.connectivity.tunnel.metering.client.MeteringDataSendScheduler;
import com.sap.core.connectivity.tunnel.metering.client.MeteringPacketClientProcessor;

public class NotificationConnectivityContext
extends DefaultConnectivityContext {
    public NotificationConnectivityContext(ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
    }

    protected void initializeDefaultPacketProcessors() {
        this.messagePacketProcessors.put(10, this.createMeteringPacketProcessor());
        this.messagePacketProcessors.put(100, new ResponsePacketProcessor((ConnectivityContext)this));
    }

    private MeteringPacketClientProcessor createMeteringPacketProcessor() {
        DefaultMeteringMessagePacketFactory meteringMessagePacketFactory = new DefaultMeteringMessagePacketFactory((MessagePacketFactory)this.getMessagePacketFactory());
        final MeteringDataSendScheduler scheduler = new MeteringDataSendScheduler((MeteringMessagePacketFactory)meteringMessagePacketFactory, this.serviceRegistry, this.tunnelRegistry);
        this.getTunnelRegistry().addListener((TunnelRegistryListener)new TunnelRegistryListenerAdapter(){

            public void tunnelChannelUnregistered(TunnelChannelUnregisteredEvent event) {
                scheduler.stop(event.getTunnelId());
            }
        });
        return new MeteringPacketClientProcessor((MeteringMessagePacketFactory)meteringMessagePacketFactory, scheduler);
    }
}

