/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.notification;

import com.sap.core.connectivity.tunnel.api.management.NotificationTunnelInformation;
import com.sap.core.connectivity.tunnel.core.handshake.ClientConflictHandshakeException;

class NotificationTunnelInformationImpl
implements NotificationTunnelInformation {
    private NotificationTunnelInformation.State state = NotificationTunnelInformation.State.DISCONNECTED;
    private Throwable error = null;
    private long startTimestamp = 0L;
    private NotificationTunnelInformation.Reason reason = null;

    NotificationTunnelInformationImpl() {
    }

    public NotificationTunnelInformation.State getState() {
        return this.state;
    }

    public Throwable getError() {
        return this.error;
    }

    public long getConnectTime() {
        return this.startTimestamp;
    }

    public NotificationTunnelInformation.Reason getReason() {
        return this.reason;
    }

    public void updateState(NotificationTunnelInformation.State newState) {
        this.updateState(newState, null);
    }

    public void updateState(NotificationTunnelInformation.State newState, Throwable newError) {
        this.state = newState;
        this.error = newError;
        if (this.error != null) {
            this.reason = newError instanceof ClientConflictHandshakeException ? NotificationTunnelInformation.Reason.CLIENT_CONFLICT : NotificationTunnelInformation.Reason.UNKNOWN;
        }
        this.updateTimeStamp();
    }

    private void updateTimeStamp() {
        this.startTimestamp = this.state == NotificationTunnelInformation.State.CONNECTED ? System.currentTimeMillis() : 0L;
    }
}

