/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.principalpropagation;

import com.google.gson.Gson;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.ApplicationTrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationService;
import com.sap.core.connectivity.tunnel.client.sso.CallerPrincipalImpl;
import com.sap.core.connectivity.tunnel.client.sso.InvalidSSOTokenException;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenType;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenValidator;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationRequest;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationResult;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PrincipalPropagationTokenValidator
implements SSOTokenValidator {
    @Override
    public SSOTokenType getTokenType() {
        return SSOTokenType.PrincipalPropagation;
    }

    @Override
    public TokenValidationResult validateToken(TokenValidationRequest validationRequest, ProcessingContext processingContext) throws InvalidSSOTokenException {
        TokenValidationResult tokenValidationResult = null;
        try {
            TunnelConfiguration configuration = (TunnelConfiguration)processingContext.getServiceRegistry().getService(TunnelConfiguration.class);
            this.validateApplicationTrust(validationRequest, processingContext);
            Gson gson = new Gson();
            GenericUserModel userModel = (GenericUserModel)gson.fromJson(validationRequest.getToken(), GenericUserModel.class);
            CallerPrincipalImpl callerPrincipal = this.createPrincipal(userModel);
            long tokenExpirationTime = Calendar.getInstance().getTimeInMillis() + configuration.getSSOClockSkewToleranceSeconds() * 1000L;
            tokenValidationResult = new TokenValidationResult(tokenExpirationTime, callerPrincipal);
        }
        catch (InvalidSSOTokenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidSSOTokenException("Unable to verify trust for principal propagation due to: ", e);
        }
        return tokenValidationResult;
    }

    private void validateApplicationTrust(TokenValidationRequest validationRequest, ProcessingContext processingContext) throws InvalidSSOTokenException {
        TrustConfigurationService trustConfigurationService = (TrustConfigurationService)processingContext.getServiceRegistry().getService(TrustConfigurationService.class);
        TrustConfiguration trustConfiguration = trustConfigurationService.getConfiguration(validationRequest.getTunnelId());
        String account = validationRequest.getTunnelAttributes().getAttribute("applicationAccount");
        String name = validationRequest.getTunnelAttributes().getAttribute("applicationName");
        ApplicationTrustConfiguration.ApplicationType type = ApplicationTrustConfiguration.ApplicationType.fromString((String)validationRequest.getTunnelAttributes().getAttribute("applicationType"));
        if (trustConfiguration != null) {
            for (ApplicationTrustConfiguration appTrustConfig : trustConfiguration.getApplicationConfigurations()) {
                if (!appTrustConfig.getAccount().equals(account) || !appTrustConfig.getName().equals(name) || !appTrustConfig.getApplicationType().equals((Object)type)) continue;
                if (!appTrustConfig.isEnabled()) break;
                return;
            }
        }
        throw new InvalidSSOTokenException(MessageFormat.format("The account/application/type {0}/{1}/{2} is not trusted for principal propagation!", account, name, type.toString()), account, name, type.toString());
    }

    private CallerPrincipalImpl createPrincipal(GenericUserModel userModel) {
        CallerPrincipalImpl callerPrincipal = new CallerPrincipalImpl(userModel.getName());
        for (Map.Entry<String, String> userAttr : userModel.getAttributes().entrySet()) {
            callerPrincipal.addAttribute(userAttr.getKey(), userAttr.getValue());
        }
        return callerPrincipal;
    }

    private static class GenericUserModel {
        private String name;
        private Map<String, String> attributes = new HashMap<String, String>();

        public GenericUserModel() {
        }

        public GenericUserModel(String name) {
            this();
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void addAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }
    }
}

