/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.reconnect;

import com.sap.core.connectivity.tunnel.client.reconnect.MaxReconnectAttemptsExceededException;
import com.sap.core.connectivity.tunnel.client.reconnect.Reconnectable;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.security.SecureRandom;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ReconnectScheduler {
    private static final Logger log = Logger.getLogger(ReconnectScheduler.class);
    private final Reconnectable reconnectable;
    private final int maxReconnectAttempts;
    private final int initialReconnectDelay;
    private final AtomicInteger reconnectAttempts = new AtomicInteger();
    private ScheduledExecutorService executorService;

    public ReconnectScheduler(Reconnectable reconnectable, int maxReconnectAttempts, int initialReconnectDelay) {
        this.reconnectable = reconnectable;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.initialReconnectDelay = initialReconnectDelay;
    }

    public void schedule() throws MaxReconnectAttemptsExceededException {
        if (this.reconnectAttempts.get() >= this.maxReconnectAttempts) {
            throw new MaxReconnectAttemptsExceededException(String.format("No connection to %s after %d attempts", this.reconnectable.getDescription(), this.reconnectAttempts.get()));
        }
        int delay = this.getDelay();
        log.info((Object)String.format("Reconnect attempt #%d to %s - sleeping for %d seconds", this.reconnectAttempts.get(), this.reconnectable.getDescription(), delay));
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DefaultThreadFactory("reconnector"));
        }
        ReconnectTask reconnectTask = new ReconnectTask();
        this.executorService.schedule(reconnectTask, (long)delay, TimeUnit.SECONDS);
    }

    public void reset() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.reconnectAttempts.set(0);
    }

    private int getDelay() {
        if (this.reconnectAttempts.incrementAndGet() == 1) {
            return new SecureRandom().nextInt(this.initialReconnectDelay) + 1;
        }
        return this.initialReconnectDelay * this.reconnectAttempts.get();
    }

    private class ReconnectTask
    implements Runnable {
        private ReconnectTask() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connecting to  " + ReconnectScheduler.this.reconnectable.getDescription()));
            }
            ReconnectScheduler.this.reconnectable.reconnect();
        }
    }
}

