/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.ssl;

import com.sap.core.connectivity.spi.util.SSLUtil;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.ssl.TunnelClientSSLConfigurationService;
import com.sap.core.connectivity.tunnel.client.ssl.TunnelClientSSLHandshakeValidator;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLEngine;

public class DefaultTunnelClientSSLConfigurationService
implements TunnelClientSSLConfigurationService {
    private static final String SSL_HANDLER_NAME = "ssl";

    public void addSSLHandler(ChannelPipeline pipeline, TunnelEndpoint endpoint, InetSocketAddress peerAddress) {
        try {
            SSLEngine engine = endpoint.getSSLContext().createSSLEngine(peerAddress.getHostName(), peerAddress.getPort());
            engine.setUseClientMode(true);
            SSLUtil.disableSSLProtocols((SSLEngine)engine);
            pipeline.addFirst(SSL_HANDLER_NAME, (ChannelHandler)new SslHandler(engine));
        }
        catch (GeneralSecurityException e) {
            throw new TunnelHandshakeException("Could not initialize client SSL support", (Throwable)e);
        }
    }

    public void addSSLHandshakeValidator(ChannelPipeline pipeline, InetSocketAddress sslEndpoint) {
        ChannelHandler channelHandler = pipeline.get(SSL_HANDLER_NAME);
        if (!(channelHandler instanceof SslHandler)) {
            throw new IllegalStateException("Unable to add handshake validator, because there is no SSL handler in the current pipeline");
        }
        SslHandler sslHandler = (SslHandler)channelHandler;
        sslHandler.handshakeFuture().addListener((GenericFutureListener)new TunnelClientSSLHandshakeValidator(sslHandler, sslEndpoint));
    }
}

