/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.ssl;

import com.sap.core.connectivity.tunnel.client.ssl.TunnelClientSSLHandshakeException;
import com.sap.core.connectivity.tunnel.core.util.CertificateUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;

class TunnelClientSSLHandshakeValidator
implements GenericFutureListener<Future<Channel>> {
    private static final Logger LOGGER = Logger.getLogger(TunnelClientSSLHandshakeValidator.class);
    private static final String WILDCARD = "*.";
    private static final String DOT = ".";
    private static final Pattern CN_VALIDATION_REGEX = Pattern.compile("^(([*][.])?)(?!([*][.]|[.]))([.]?((?<=[a-zA-Z0-9])-)?[a-zA-Z0-9])+$");
    private final SslHandler sslHandler;
    private final String sslEndpointHostname;

    public TunnelClientSSLHandshakeValidator(SslHandler sslHandler, InetSocketAddress sslEndpoint) {
        this.sslHandler = sslHandler;
        this.sslEndpointHostname = this.formatDNSName(sslEndpoint.getHostName());
    }

    public void operationComplete(Future<Channel> completeFuture) throws Exception {
        ChannelPipeline pipeline = ((Channel)completeFuture.get()).pipeline();
        if (!completeFuture.isSuccess()) {
            pipeline.fireExceptionCaught(completeFuture.cause());
            return;
        }
        try {
            List<String> serverCertificateDNSNames = this.retrieveServerCertificateDNSNames();
            this.assertServerCertificateMatchesSSLEndpoint(serverCertificateDNSNames);
        }
        catch (Exception ex) {
            pipeline.fireExceptionCaught((Throwable)ex);
        }
    }

    private List<String> retrieveServerCertificateDNSNames() throws TunnelClientSSLHandshakeException {
        List<String> certificateDNSNames;
        X509Certificate serverCertificate = this.extractServerCertificate();
        String commonName = this.extractCertificateCN(serverCertificate);
        List<String> alternativeDNSNames = this.extractSubjectAlternativeDNSNames(serverCertificate);
        if (alternativeDNSNames == null || alternativeDNSNames.isEmpty()) {
            certificateDNSNames = Collections.singletonList(commonName);
        } else {
            certificateDNSNames = new ArrayList<String>(alternativeDNSNames);
            certificateDNSNames.add(commonName);
            certificateDNSNames = Collections.unmodifiableList(certificateDNSNames);
        }
        return certificateDNSNames;
    }

    private void assertServerCertificateMatchesSSLEndpoint(List<String> serverCertificateDNSNames) throws TunnelClientSSLHandshakeException {
        for (String dnsName : serverCertificateDNSNames) {
            if (!this.dnsNameMatchesSSLEndpoint(dnsName)) continue;
            return;
        }
        throw new TunnelClientSSLHandshakeException(String.format("SSL endpoint does not match server certificate DNS names " + serverCertificateDNSNames, new Object[0]));
    }

    private String extractCertificateCN(X509Certificate serverCertificate) throws TunnelClientSSLHandshakeException {
        String commonName;
        try {
            commonName = CertificateUtils.extractSubjectTokenValue((X509Certificate)serverCertificate, (String)"CN=");
        }
        catch (Exception ex) {
            throw new TunnelClientSSLHandshakeException("Unable to extract CN value from the server certificate");
        }
        if (StringUtil.isNullOrEmpty((String)commonName)) {
            throw new TunnelClientSSLHandshakeException("Unable to find CN in the server certificate");
        }
        commonName = this.formatDNSName(commonName);
        this.assertDNSName(commonName);
        return commonName;
    }

    private Collection<List<?>> getSubjectAlternativeNames(X509Certificate serverCertificate) {
        try {
            return serverCertificate.getSubjectAlternativeNames();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error during retrieval of SANs", ex);
        }
    }

    private String formatDNSName(String dnsName) {
        return dnsName.toLowerCase(Locale.ROOT);
    }

    private void assertDNSName(String dnsName) throws TunnelClientSSLHandshakeException {
        if (!CN_VALIDATION_REGEX.matcher(dnsName).matches()) {
            throw new TunnelClientSSLHandshakeException("Server certificate contains unsupported DNS name");
        }
    }

    private X509Certificate extractServerCertificate() {
        Certificate certificate;
        try {
            SSLSession sslSession = this.sslHandler.engine().getSession();
            Certificate[] sessionCertificates = sslSession.getPeerCertificates();
            certificate = sessionCertificates[0];
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error during retrieval of server certificate", ex);
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalStateException("Unable to find valid server certificate in the current session");
        }
        return (X509Certificate)certificate;
    }

    private boolean dnsNameMatchesSSLEndpoint(String commonName) {
        String convertedCN = commonName;
        if (commonName.startsWith(WILDCARD)) {
            convertedCN = this.unifyHostnameAndCNPrefix(commonName, this.sslEndpointHostname);
        }
        return this.sslEndpointHostname.equals(convertedCN);
    }

    private String unifyHostnameAndCNPrefix(String commonName, String peerHost) {
        String unifiedCN = commonName;
        if (commonName.contains(DOT) && peerHost.contains(DOT)) {
            unifiedCN = commonName.replaceFirst(Pattern.quote(commonName.substring(0, commonName.indexOf(DOT, 0))), peerHost.substring(0, peerHost.indexOf(DOT, 0)));
            LOGGER.trace((Object)String.format("Converting server certificate CN: %s to %s, due to wildcard", commonName, unifiedCN));
        }
        return unifiedCN;
    }

    private List<String> extractSubjectAlternativeDNSNames(X509Certificate serverCertificate) throws TunnelClientSSLHandshakeException {
        ArrayList<String> sanDNSNames = null;
        Collection<List<?>> subjectAlternativeNames = this.getSubjectAlternativeNames(serverCertificate);
        if (subjectAlternativeNames != null) {
            sanDNSNames = new ArrayList<String>(subjectAlternativeNames.size());
            for (List<?> sanEntry : subjectAlternativeNames) {
                int type = this.getType(sanEntry);
                if (type != 2) continue;
                String dnsName = this.formatDNSName(this.getDNSValue(sanEntry));
                this.assertDNSName(dnsName);
                sanDNSNames.add(dnsName);
            }
        }
        return sanDNSNames;
    }

    private int getType(List<?> sanEntry) {
        Object type = sanEntry.get(0);
        if (!(type instanceof Integer)) {
            throw new IllegalStateException("Invalid SAN entry type: " + type);
        }
        return (Integer)type;
    }

    private String getDNSValue(List<?> sanEntry) {
        Object value = sanEntry.get(1);
        if (!(value instanceof String)) {
            throw new IllegalStateException("Invalid SAN entry value: " + value);
        }
        return (String)value;
    }
}

