/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.spi.sso.CallerPrincipal;
import com.sap.core.connectivity.spi.sso.CallerPrincipalProvider;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CallerPrincipalProviderImpl
implements CallerPrincipalProvider {
    private static final Logger log = Logger.getLogger(CallerPrincipalProviderImpl.class);
    private final ConcurrentHashMap<Integer, CallerPrincipal> principalsMap = new ConcurrentHashMap();

    public CallerPrincipal getPrincipal(int connectionId) {
        return this.principalsMap.get(connectionId);
    }

    public void assign(int connectionId, CallerPrincipal principal) {
        if (principal != null) {
            this.principalsMap.put(connectionId, principal);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Assigned principal: '%s'", principal));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Could not assing principal. No principal is available for connection with ID: '%s'", ChannelUtil.formatConnectionId((int)connectionId)));
        }
    }

    public void unassign(int connectionId) {
        CallerPrincipal principal = this.principalsMap.remove(connectionId);
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unassigned principal: '%s'", principal));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Could not unassing principal. No principal is found for connection with ID: '%s'", ChannelUtil.formatConnectionId((int)connectionId)));
        }
    }
}

