/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.IdentityProviderConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationService;
import com.sap.core.connectivity.tunnel.client.sso.CallerPrincipalImpl;
import com.sap.core.connectivity.tunnel.client.sso.InvalidSSOTokenException;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenType;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenValidator;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationRequest;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationResult;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class JWTValidator
implements SSOTokenValidator {
    private static final Logger LOGGER = Logger.getLogger(JWTValidator.class);
    private static final String JWT_USER_NAME_PROPERTY = "user_name";
    private static final JsonParser PARSER = new JsonParser();
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public SSOTokenType getTokenType() {
        return SSOTokenType.JWT;
    }

    @Override
    public TokenValidationResult validateToken(TokenValidationRequest validationRequest, ProcessingContext processingContext) throws InvalidSSOTokenException {
        TokenValidationResult tokenValidationResult = null;
        try {
            TunnelConfiguration configuration = (TunnelConfiguration)processingContext.getServiceRegistry().getService(TunnelConfiguration.class);
            String tokenKey = this.decodeJWT(validationRequest, processingContext);
            CallerPrincipalImpl callerPrincipal = this.createPrincipal(tokenKey);
            long tokenExpirationTime = Calendar.getInstance().getTimeInMillis() + configuration.getSSOClockSkewToleranceSeconds() * 1000L;
            tokenValidationResult = new TokenValidationResult(tokenExpirationTime, callerPrincipal);
        }
        catch (InvalidSSOTokenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidSSOTokenException("Unable to verify trust for JWT principal propagation due to: ", e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("successfully validated JWT for " + validationRequest.getTunnelId()));
        }
        return tokenValidationResult;
    }

    private CallerPrincipalImpl createPrincipal(String jwt) {
        JsonObject jsonObject = PARSER.parse(jwt).getAsJsonObject();
        String username = jsonObject.get(JWT_USER_NAME_PROPERTY).getAsString();
        CallerPrincipalImpl callerPrincipal = new CallerPrincipalImpl(username);
        for (Map.Entry entry : jsonObject.entrySet()) {
            String attributeKey = (String)entry.getKey();
            JsonElement attributeValue = (JsonElement)entry.getValue();
            if (attributeValue.isJsonNull()) continue;
            if (attributeValue.isJsonObject()) {
                this.addJsonObject(callerPrincipal, attributeKey, attributeValue);
                continue;
            }
            if (attributeValue.isJsonArray()) {
                callerPrincipal.addMultiValueAttribute(attributeKey, this.jsonArrayToList(attributeValue.getAsJsonArray()));
                continue;
            }
            callerPrincipal.addAttribute(attributeKey, attributeValue.getAsString());
        }
        return callerPrincipal;
    }

    private void addJsonObject(CallerPrincipalImpl callerPrincipal, String attributeKey, JsonElement attributeValue) {
        int size = attributeValue.getAsJsonObject().entrySet().size();
        if (size > 0) {
            String prettyJson = GSON.toJson(attributeValue);
            callerPrincipal.addAttribute(attributeKey, prettyJson);
        } else {
            callerPrincipal.addAttribute(attributeKey, "{}");
        }
    }

    private List<String> jsonArrayToList(JsonArray jsonArray) {
        Type type = new TypeToken<List<String>>(){}.getType();
        List fromJson = (List)GSON.fromJson((JsonElement)jsonArray, type);
        return fromJson;
    }

    private String decodeJWT(TokenValidationRequest validationRequest, ProcessingContext processingContext) throws InvalidSSOTokenException {
        String tunnelId = validationRequest.getTunnelId();
        String account = validationRequest.getTunnelAttributes().getAttribute("applicationAccount");
        TrustConfigurationService trustConfigurationService = (TrustConfigurationService)processingContext.getServiceRegistry().getService(TrustConfigurationService.class);
        TrustConfiguration trustConfiguration = trustConfigurationService.getConfiguration(tunnelId);
        String jwt = validationRequest.getToken();
        if (trustConfiguration != null) {
            for (IdentityProviderConfiguration idpConfig : trustConfiguration.getIdPConfigurations()) {
                try {
                    String publicKey = new String(idpConfig.getPublicKey());
                    return JwtHelper.decodeAndVerify((String)jwt, (SignatureVerifier)new RsaVerifier(publicKey)).getClaims();
                }
                catch (RuntimeException e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)e);
                }
            }
        }
        throw new InvalidSSOTokenException(MessageFormat.format("The account {0} is not trusted for JWT principal propagation!", account));
    }
}

