/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.cloud.auditlog.AuditLogMessageFactory;
import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.MessagePacketFactory;
import com.sap.core.connectivity.spi.sso.CallerPrincipal;
import com.sap.core.connectivity.spi.sso.CallerPrincipalProvider;
import com.sap.core.connectivity.spi.statistics.PerformanceStatistics;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.tunnel.api.audit.AuditProvider;
import com.sap.core.connectivity.tunnel.api.audit.TunnelSecurityEventAuditMessage;
import com.sap.core.connectivity.tunnel.api.mapping.AuthenticationMode;
import com.sap.core.connectivity.tunnel.api.mapping.HostMapping;
import com.sap.core.connectivity.tunnel.client.sso.InvalidSSOSessionException;
import com.sap.core.connectivity.tunnel.client.sso.InvalidSSOTokenException;
import com.sap.core.connectivity.tunnel.client.sso.SSOSessionService;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSOClientProcessor
implements MessagePacketProcessor {
    private static final Logger log = Logger.getLogger(SSOClientProcessor.class);
    private final SSOSessionService ssoClientSessionService;
    private final CallerPrincipalProvider principalProvider;

    public SSOClientProcessor(ConnectivityContext connectivityContext) {
        this.ssoClientSessionService = (SSOSessionService)connectivityContext.getServiceRegistry().getService(SSOSessionService.class);
        this.principalProvider = (CallerPrincipalProvider)connectivityContext.getServiceRegistry().getService(CallerPrincipalProvider.class);
    }

    public boolean acceptsPacket(MessagePacket packet) {
        return "system".equals(packet.getOwner());
    }

    public boolean processPacket(MessagePacket packet, Channel channel, ProcessingContext processingContext) {
        block6: {
            try {
                switch (packet.getType()) {
                    case 1: {
                        return this.assignPrincipal(packet, channel, processingContext);
                    }
                    case 2: {
                        return this.unassingPrincipal(packet);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to process SSO token", (Throwable)e);
                if ($assertionsDisabled || AssertionUtil.propagateException((Throwable)e)) break block6;
                throw new AssertionError();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignPrincipal(MessagePacket packet, Channel channel, ProcessingContext processingContext) {
        String ssoSessionId = packet.getProperty("ssoSessionId");
        String ssoToken = packet.getProperty("ssoToken");
        String ssoTokenType = packet.getProperty("ssoTokenType");
        if (!this.isSSOHandlingRequired(packet, processingContext, ssoSessionId, ssoToken)) {
            return true;
        }
        try {
            PerformanceStatistics stats = processingContext.getPerformanceStatistics(packet.getConnectionId());
            stats.getValidateSSOTokenTime().startMeasure();
            Integer sessionId = null;
            try {
                if (ssoSessionId != null) {
                    sessionId = this.validateExistingSession(ssoSessionId);
                } else if (ssoToken != null) {
                    sessionId = this.getOrCreateSession(channel, processingContext, ssoToken, ssoTokenType);
                }
            }
            finally {
                stats.getValidateSSOTokenTime().stopMeasure();
                long time = stats.getValidateSSOTokenTime().getElapsedTime();
                if (time > 50L) {
                    log.warn((Object)("SLOW Opening connection validate token took: " + time));
                }
            }
            CallerPrincipal principal = this.ssoClientSessionService.getPrincipal(sessionId);
            this.principalProvider.assign(packet.getConnectionId(), principal);
        }
        catch (InvalidSSOSessionException e) {
            this.logSSOValidationFailedAuditEvent(packet, processingContext, "invalidSession", ssoSessionId);
            this.rejectClientConnection(packet.getConnectionId(), processingContext, e.getMessage());
            return false;
        }
        catch (InvalidSSOTokenException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SSO token validation failed.", (Throwable)e);
            }
            this.logSSOValidationFailedAuditEvent(packet, processingContext, "validationFailed", ssoSessionId, e.getAdditionalAuditAttributes());
            this.rejectClientConnection(packet.getConnectionId(), processingContext, "SSO token validation failed. Make sure trust is configured correctly in the cloud connector to enable principal propagation, if token has not expired yet.");
            return false;
        }
        return true;
    }

    private boolean isSSOHandlingRequired(MessagePacket packet, ProcessingContext processingContext, String ssoSessionId, String ssoToken) {
        if (ssoSessionId == null && ssoToken == null) {
            return false;
        }
        String protocolStr = packet.getProperty("connectionProtocol");
        ConnectionProtocol protocol = ConnectionProtocol.valueOf((String)protocolStr);
        if (ConnectionProtocol.RFC.equals((Object)protocol)) {
            return true;
        }
        String virtualHost = packet.getProperty("host");
        String virtualPort = packet.getProperty("port");
        HostMapping hostMapping = null;
        if (virtualHost != null && virtualPort != null) {
            hostMapping = processingContext.getMappingResolver().getHostMapping(virtualHost, virtualPort);
        }
        if (hostMapping == null || AuthenticationMode.NONE.equals((Object)hostMapping.getAuthenticationMode())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("SSO handling not required. Either the host mapping was not found or the authentication mode is set to '%s'.Protocol '%s'; Virtual host '%s'; Virtual port '%s'; Connection ID '%s'", AuthenticationMode.NONE.name(), protocol, virtualHost, virtualPort, packet.getConnectionId()));
            }
            return false;
        }
        return true;
    }

    private Integer validateExistingSession(String ssoSessionId) throws InvalidSSOSessionException {
        try {
            Integer sessionId = Integer.parseInt(ssoSessionId);
            if (!this.ssoClientSessionService.sessionExists(sessionId)) {
                throw new InvalidSSOSessionException("Invalid or non existing session received!");
            }
            return sessionId;
        }
        catch (NumberFormatException e) {
            throw new InvalidSSOSessionException("Invalid or non existing session received!", e);
        }
    }

    private Integer getOrCreateSession(Channel channel, ProcessingContext processingContext, String ssoToken, String ssoTokenType) throws InvalidSSOTokenException {
        return this.ssoClientSessionService.getOrCreateSession(ssoToken, ssoTokenType, processingContext, channel);
    }

    private boolean unassingPrincipal(MessagePacket packet) {
        this.principalProvider.unassign(packet.getConnectionId());
        return true;
    }

    private void rejectClientConnection(int connectionId, ProcessingContext processingContext, String message) {
        MessagePacketFactory factory = processingContext.getMessagePacketFactory();
        MessagePacket errorPacket = factory.createErrorPacket(connectionId, 203, message);
        this.writeToTunnel(processingContext, errorPacket);
    }

    private void writeToTunnel(ProcessingContext processingContext, MessagePacket messagePacket) {
        block2: {
            try {
                processingContext.getTunnel().write(messagePacket);
            }
            catch (NoChannelsAvailableException e) {
                log.error((Object)"No channels available", (Throwable)e);
                if ($assertionsDisabled || AssertionUtil.propagateException((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
    }

    private void logSSOValidationFailedAuditEvent(MessagePacket packet, ProcessingContext processingContext, String objectID, String ssoSessionId) {
        this.logSSOValidationFailedAuditEvent(packet, processingContext, objectID, ssoSessionId, new HashMap<String, String>());
    }

    private void logSSOValidationFailedAuditEvent(MessagePacket packet, ProcessingContext processingContext, String objectID, String ssoSessionId, Map<String, String> additionalAuditAttributes) {
        try {
            AuditProvider auditProvider = (AuditProvider)processingContext.getServiceRegistry().getService(AuditProvider.class);
            String tunnelId = processingContext.getTunnel().getId();
            AuditLogMessageFactory auditLogger = auditProvider.getAuditLogMessageFactory(tunnelId);
            String virtualHost = packet.getProperty("host");
            String virtualPort = packet.getProperty("port");
            TunnelSecurityEventAuditMessage message = (TunnelSecurityEventAuditMessage)auditLogger.createAuditLogMessage(TunnelSecurityEventAuditMessage.class);
            message.addCustomAttribute("tunnelId", tunnelId);
            message.addCustomAttribute("sessionId", ssoSessionId);
            for (Map.Entry<String, String> auditEntry : additionalAuditAttributes.entrySet()) {
                message.addCustomAttribute(auditEntry.getKey(), auditEntry.getValue());
            }
            message.setObjectId(objectID);
            message.setObjectName(virtualHost + ":" + virtualPort);
            message.setAction("PRINCIPAL_DENIED");
            message.log(this.getClass());
        }
        catch (Exception e) {
            log.error((Object)"Unable to write audit log.", (Throwable)e);
        }
    }
}

