/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.sso.CallerPrincipal;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableService;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationService;
import com.sap.core.connectivity.tunnel.api.trust.TunnelAttributes;
import com.sap.core.connectivity.tunnel.client.TunnelInformationStore;
import com.sap.core.connectivity.tunnel.client.sso.InvalidSSOTokenException;
import com.sap.core.connectivity.tunnel.client.sso.SSOSessionService;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenType;
import com.sap.core.connectivity.tunnel.client.sso.SSOTokenValidator;
import com.sap.core.connectivity.tunnel.client.sso.SessionInfoStore;
import com.sap.core.connectivity.tunnel.client.sso.SessionInformation;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationRequest;
import com.sap.core.connectivity.tunnel.client.sso.TokenValidationResult;
import com.sap.core.connectivity.tunnel.client.sso.TrustConfigurationServiceImpl;
import com.sap.core.connectivity.tunnel.client.sso.TrustConfigurationServiceListener;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SSOClientSessionService
implements TrustConfigurationServiceListener,
SSOSessionService {
    private final Logger log = Logger.getLogger(SSOClientSessionService.class);
    private final Map<SSOTokenType, SSOTokenValidator> tokenValidators = new HashMap<SSOTokenType, SSOTokenValidator>();
    private final SessionInfoStore sessionsStore;
    private final ServiceRegistry serviceRegistry;
    private TunnelInformationStore infoStore;

    public SSOClientSessionService(ServiceRegistry serviceRegistry, TunnelInformationStore infoStore) {
        this.serviceRegistry = serviceRegistry;
        this.infoStore = infoStore;
        TrustConfigurationServiceImpl trustConfigurationService = new TrustConfigurationServiceImpl(this.serviceRegistry);
        trustConfigurationService.addListener(this);
        this.serviceRegistry.registerService(TrustConfigurationService.class, (TunnelConsumableService)trustConfigurationService);
        this.sessionsStore = new SessionInfoStore();
    }

    @Override
    public void start(int invalidationPeriod, TimeUnit timeUnit) {
        ServiceLoader<SSOTokenValidator> serviceLoader = ServiceLoader.load(SSOTokenValidator.class);
        for (SSOTokenValidator tokenValidator : serviceLoader) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found SSO token validator implementation: " + tokenValidator.getClass().getName()));
            }
            this.registerSSOTokenValidator(tokenValidator);
        }
        this.sessionsStore.start(invalidationPeriod, timeUnit);
    }

    @Override
    public boolean isStarted() {
        return this.sessionsStore.isStarted();
    }

    void registerSSOTokenValidator(SSOTokenValidator tokenValidator) {
        this.tokenValidators.put(tokenValidator.getTokenType(), tokenValidator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreateSession(String ssoToken, String ssoTokenType, ProcessingContext processingContext, Channel channel) throws InvalidSSOTokenException {
        Integer sessionId = this.sessionsStore.getOrCreateSessionId(ssoToken);
        SessionInformation session = this.sessionsStore.getSession(sessionId);
        if (session != null) {
            session.updateExpirationTimeStamp(this.generateNewSessionExpirationTimeStamp());
            if (session == this.sessionsStore.getSession(sessionId)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reusing existing session with id " + sessionId));
                }
                return sessionId;
            }
        }
        while (true) {
            Integer n = sessionId = this.sessionsStore.getOrCreateSessionId(ssoToken);
            synchronized (n) {
                if (sessionId == this.sessionsStore.getSessionId(ssoToken)) {
                    session = this.sessionsStore.getSession(sessionId);
                    if (session == null) {
                        try {
                            TunnelAttributes tunnelAttributes = this.infoStore.getTunnelAttributes(channel);
                            session = this.createSession(ssoToken, ssoTokenType, processingContext, tunnelAttributes);
                            if (!this.sessionsStore.storeSession(sessionId, session)) {
                                this.log.error((Object)String.format("Session with id %s cannot be stored", sessionId));
                            }
                        }
                        catch (InvalidSSOTokenException ex) {
                            if (!this.sessionsStore.releaseSessionId(ssoToken, sessionId)) {
                                this.log.error((Object)String.format("Session id %s cannot be released", sessionId));
                            }
                            throw ex;
                        }
                    }
                    return sessionId;
                }
            }
        }
    }

    private long generateNewSessionExpirationTimeStamp() {
        TunnelConfiguration configuration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
        long ssoTokenToleranceSeconds = configuration.getSSOClockSkewToleranceSeconds();
        return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ssoTokenToleranceSeconds);
    }

    private SessionInformation createSession(String ssoToken, String ssoTokenType, ProcessingContext processingContext, TunnelAttributes tunnelAttributes) throws InvalidSSOTokenException {
        SSOTokenType tokenType = this.getTokenType(ssoTokenType);
        SSOTokenValidator tokenValidator = this.tokenValidators.get((Object)tokenType);
        if (tokenValidator == null) {
            throw new InvalidSSOTokenException(String.format("No registered validator found for token of type %s", ssoTokenType));
        }
        String tunnelId = processingContext.getTunnel().getId();
        TokenValidationRequest validationRequest = new TokenValidationRequest(ssoToken, tunnelId, tunnelAttributes);
        TokenValidationResult validationResult = tokenValidator.validateToken(validationRequest, processingContext);
        CallerPrincipal principal = validationResult.getPrincipal();
        long tokenValidity = validationResult.getTokenExpirationTime();
        return new SessionInformation(ssoToken, principal, tokenValidity);
    }

    private SSOTokenType getTokenType(String ssoTokenType) throws InvalidSSOTokenException {
        try {
            return SSOTokenType.fromString(ssoTokenType);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSSOTokenException(String.format("Unknown token type: %s", ssoTokenType));
        }
    }

    @Override
    public CallerPrincipal getPrincipal(Integer sessionId) throws InvalidSSOTokenException {
        SessionInformation session = this.sessionsStore.getSession(sessionId);
        if (session == null) {
            throw new InvalidSSOTokenException(String.format("Session with id %s doesn't exist", sessionId));
        }
        return session.getPrincipal();
    }

    public long getSessionExpirationTimeStamp(Integer sessionId) throws InvalidSSOTokenException {
        SessionInformation session = this.sessionsStore.getSession(sessionId);
        if (session == null) {
            throw new InvalidSSOTokenException(String.format("Session with id %s doesn't exist", sessionId));
        }
        return session.getExpirationTimeStamp();
    }

    @Override
    public boolean sessionExists(Integer sessionId) {
        return this.sessionsStore.getSession(sessionId) != null;
    }

    @Override
    public void clearExpiredSessions() {
        this.sessionsStore.invalidateExpiredSessions();
    }

    @Override
    public void configurationChanged(TrustConfigurationServiceListener.TrustConfigurationChangeType changeType) {
        switch (changeType) {
            case REMOVED: 
            case DISABLED: {
                this.sessionsStore.invalidateAllSessions();
                break;
            }
        }
    }

    public void shutdown() {
        this.sessionsStore.shutdown();
        TrustConfigurationServiceImpl trustConfigurationService = (TrustConfigurationServiceImpl)this.serviceRegistry.getService(TrustConfigurationService.class);
        trustConfigurationService.removeListener(this);
    }
}

