/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.tunnel.client.sso.SessionInformation;
import com.sap.core.connectivity.tunnel.client.sso.Sha256Generator;
import com.sap.core.connectivity.tunnel.core.impl.AbstractScheduledExecutionService;
import com.sap.core.connectivity.tunnel.core.util.Optional;
import java.text.MessageFormat;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

class SessionInfoStore
extends AbstractScheduledExecutionService {
    private static final Logger log = Logger.getLogger(SessionInfoStore.class);
    private static final Optional<SessionInformation> INITIAL_SESSION = Optional.absent();
    private final ConcurrentMap<Integer, Optional<SessionInformation>> sessionsMap = new ConcurrentHashMap<Integer, Optional<SessionInformation>>();
    private final ConcurrentMap<String, Integer> tokenHashToSessionIdMap = new ConcurrentHashMap<String, Integer>();
    private static final Sha256Generator shaGenerator = new Sha256Generator();

    SessionInfoStore() {
    }

    protected void execute() {
        this.invalidateExpiredSessions();
    }

    public Integer getOrCreateSessionId(String ssoToken) {
        this.checkStarted();
        String ssoTokenHash = shaGenerator.generate(ssoToken);
        Integer sessionId;
        while ((sessionId = (Integer)this.tokenHashToSessionIdMap.get(ssoTokenHash)) == null || this.sessionsMap.get(sessionId) == null) {
            if (sessionId != null) continue;
            Integer newSessionId = new Integer(SessionIdGenerator.generateId());
            sessionId = this.tokenHashToSessionIdMap.putIfAbsent(ssoTokenHash, newSessionId);
            if (sessionId == null) {
                this.sessionsMap.put(newSessionId, INITIAL_SESSION);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generated new session id " + newSessionId));
                }
                return newSessionId;
            }
            SessionIdGenerator.releaseSessionId(newSessionId);
        }
        return sessionId;
    }

    public Integer getSessionId(String ssoToken) {
        Integer sessionId;
        this.checkStarted();
        String ssoTokenHash = shaGenerator.generate(ssoToken);
        while ((sessionId = (Integer)this.tokenHashToSessionIdMap.get(ssoTokenHash)) != null && this.sessionsMap.get(sessionId) == null) {
        }
        return sessionId;
    }

    public boolean releaseSessionId(String ssoToken, Integer sessionId) {
        this.checkStarted();
        String ssoTokenHash = shaGenerator.generate(ssoToken);
        boolean sessionRemoved = this.removeSession(ssoTokenHash, sessionId, INITIAL_SESSION);
        if (sessionRemoved && log.isDebugEnabled()) {
            log.debug((Object)("Released session id " + sessionId));
        }
        return sessionRemoved;
    }

    public SessionInformation getSession(Integer sessionId) {
        this.checkStarted();
        return this.processSession(sessionId);
    }

    public boolean storeSession(Integer sessionId, SessionInformation session) {
        this.checkStarted();
        boolean sessionStored = this.replaceSession(sessionId, INITIAL_SESSION, (Optional<SessionInformation>)Optional.of((Object)session));
        if (sessionStored && log.isDebugEnabled()) {
            log.debug((Object)("Stored session with id " + sessionId));
        }
        return sessionStored;
    }

    public boolean replaceSession(Integer sessionId, SessionInformation oldSession, SessionInformation newSession) {
        this.checkStarted();
        boolean sessionReplaced = this.replaceSession(sessionId, (Optional<SessionInformation>)Optional.of((Object)oldSession), (Optional<SessionInformation>)Optional.of((Object)newSession));
        if (sessionReplaced && log.isDebugEnabled()) {
            log.debug((Object)("Replaced session with id " + sessionId));
        }
        return sessionReplaced;
    }

    public boolean removeSession(Integer sessionId, SessionInformation session) {
        this.checkStarted();
        boolean sessionRemoved = this.removeSession(session.getSsoTokenHash(), sessionId, (Optional<SessionInformation>)Optional.of((Object)session));
        if (sessionRemoved && log.isDebugEnabled()) {
            log.debug((Object)("Removed session with id " + sessionId));
        }
        return sessionRemoved;
    }

    public void invalidateExpiredSessions() {
        this.checkStarted();
        long start = System.nanoTime();
        int count = 0;
        Set sessionsId = this.sessionsMap.keySet();
        int size = sessionsId.size();
        for (Integer sessionId : sessionsId) {
            SessionInformation session = this.processSession(sessionId);
            if (session != null) continue;
            ++count;
        }
        long time = System.nanoTime() - start;
        log.info((Object)MessageFormat.format("Clear expired sessions: {0}/{1} took {2}", count, size, TimeUnit.NANOSECONDS.toMillis(time)));
    }

    public void invalidateAllSessions() {
        if (this.sessionsMap.size() > 0 || this.tokenHashToSessionIdMap.size() > 0) {
            this.checkStarted();
        }
        this.sessionsMap.clear();
        this.tokenHashToSessionIdMap.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invalidated all sessions");
        }
    }

    private SessionInformation processSession(Integer sessionId) {
        Optional session;
        block4: {
            do {
                if ((session = (Optional)this.sessionsMap.get(sessionId)) == null || session.equals(INITIAL_SESSION)) {
                    return null;
                }
                if (((SessionInformation)session.get()).getExpirationTimeStamp() >= System.currentTimeMillis()) break block4;
            } while (!this.sessionsMap.remove(sessionId, session));
            if (this.tokenHashToSessionIdMap.remove(((SessionInformation)session.get()).getSsoTokenHash(), sessionId)) {
                SessionIdGenerator.releaseSessionId(sessionId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalidated session with id " + sessionId));
            }
            return null;
        }
        return (SessionInformation)session.get();
    }

    private boolean replaceSession(Integer sessionId, Optional<SessionInformation> oldSession, Optional<SessionInformation> newSession) {
        boolean sessionReplaced = false;
        String ssoTokenHash = ((SessionInformation)newSession.get()).getSsoTokenHash();
        if (sessionId == this.tokenHashToSessionIdMap.get(ssoTokenHash)) {
            sessionReplaced = this.sessionsMap.replace(sessionId, oldSession, newSession);
        }
        return sessionReplaced;
    }

    private boolean removeSession(String tokenHash, Integer sessionId, Optional<SessionInformation> session) {
        if (sessionId == this.tokenHashToSessionIdMap.get(tokenHash) && this.sessionsMap.remove(sessionId, session) && this.tokenHashToSessionIdMap.remove(tokenHash, sessionId)) {
            SessionIdGenerator.releaseSessionId(sessionId);
            return true;
        }
        return false;
    }

    private static class SessionIdGenerator {
        private static final Random RANDOM_GENERATOR = new Random();
        private static final Object MAP_VALUE_FOR_SIMULATING_CONCURRENT_SET = new Object();
        private static final ConcurrentMap<Integer, Object> ALL_SESSIONS_IDS = new ConcurrentHashMap<Integer, Object>();

        private SessionIdGenerator() {
        }

        static int generateId() {
            int id = RANDOM_GENERATOR.nextInt();
            while (ALL_SESSIONS_IDS.putIfAbsent(id, MAP_VALUE_FOR_SIMULATING_CONCURRENT_SET) != null) {
                ++id;
            }
            return id;
        }

        static void releaseSessionId(int sessionId) {
            ALL_SESSIONS_IDS.remove(sessionId);
        }
    }
}

