/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.spi.sso.CallerPrincipal;
import com.sap.core.connectivity.tunnel.client.sso.Sha256Generator;
import java.util.concurrent.atomic.AtomicLong;

class SessionInformation {
    private static final Sha256Generator shaGenerator = new Sha256Generator();
    private final String ssoTokenHash;
    private final CallerPrincipal principal;
    private final AtomicLong expirationTimestamp;

    SessionInformation(String ssoToken, CallerPrincipal principal, long expirationTimeStamp) {
        this.ssoTokenHash = shaGenerator.generate(ssoToken);
        this.principal = principal;
        this.expirationTimestamp = new AtomicLong(expirationTimeStamp);
    }

    public String getSsoTokenHash() {
        return this.ssoTokenHash;
    }

    public CallerPrincipal getPrincipal() {
        return this.principal;
    }

    public long getExpirationTimeStamp() {
        return this.expirationTimestamp.get();
    }

    public void updateExpirationTimeStamp(long newExpirationTimeStamp) {
        this.expirationTimestamp.set(newExpirationTimeStamp);
    }
}

