/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.tunnel.api.sso.AbstractTrustedEntityConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.ApplicationTrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.IdentityProviderConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfiguration;
import java.util.ArrayList;

class TrustConfigurationMerger {
    TrustConfigurationMerger() {
    }

    TrustConfiguration mergeConfigurations(TrustConfiguration oldConfiguration, TrustConfiguration newConfiguration) {
        if (oldConfiguration == null) {
            return newConfiguration;
        }
        ArrayList<IdentityProviderConfiguration> idpConfigurations = new ArrayList<IdentityProviderConfiguration>();
        for (IdentityProviderConfiguration idpConfiguration : newConfiguration.getIdPConfigurations()) {
            boolean enabledState = this.getEnabledState(oldConfiguration, (AbstractTrustedEntityConfiguration)idpConfiguration);
            idpConfigurations.add(new IdentityProviderConfiguration(idpConfiguration, enabledState));
        }
        ArrayList<ApplicationTrustConfiguration> appConfigurations = new ArrayList<ApplicationTrustConfiguration>();
        for (ApplicationTrustConfiguration appConfiguration : newConfiguration.getApplicationConfigurations()) {
            boolean enabledState = this.getEnabledState(oldConfiguration, (AbstractTrustedEntityConfiguration)appConfiguration);
            appConfigurations.add(new ApplicationTrustConfiguration(appConfiguration, enabledState));
        }
        return new TrustConfiguration(newConfiguration.getTunnelId(), newConfiguration.getLastUpdated(), idpConfigurations, appConfigurations);
    }

    private boolean getEnabledState(TrustConfiguration oldConfiguration, AbstractTrustedEntityConfiguration newConfiguration) {
        int configurationId = newConfiguration.getId();
        for (IdentityProviderConfiguration oldIdpConfiguration : oldConfiguration.getIdPConfigurations()) {
            if (configurationId != oldIdpConfiguration.getId()) continue;
            return oldIdpConfiguration.isEnabled();
        }
        for (ApplicationTrustConfiguration oldAppConfiguration : oldConfiguration.getApplicationConfigurations()) {
            if (configurationId != oldAppConfiguration.getId()) continue;
            return oldAppConfiguration.isEnabled();
        }
        if (newConfiguration instanceof IdentityProviderConfiguration) {
            return newConfiguration.isEnabled();
        }
        return false;
    }
}

