/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.sso.ApplicationTrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.IdentityProviderConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationException;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationSerializer;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationService;
import com.sap.core.connectivity.tunnel.client.sso.TrustConfigurationMerger;
import com.sap.core.connectivity.tunnel.client.sso.TrustConfigurationServiceListener;
import com.sap.core.connectivity.tunnel.client.sso.TrustConfigurationSynchronizer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class TrustConfigurationServiceImpl
implements TrustConfigurationService {
    private static final Logger log = Logger.getLogger(TrustConfigurationServiceImpl.class);
    private final ServiceRegistry serviceRegistry;
    private final TrustConfigurationSynchronizer synchronizer;
    private final ConcurrentHashMap<String, ConfigurationCacheEntry> cache = new ConcurrentHashMap();
    private final List<TrustConfigurationServiceListener> listeners = Collections.synchronizedList(new ArrayList());

    public TrustConfigurationServiceImpl(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.synchronizer = new TrustConfigurationSynchronizer(serviceRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustConfiguration getConfiguration(String tunnelId) {
        ConfigurationCacheEntry entry = this.getCacheEntry(tunnelId);
        ReadWriteLock lock = entry.lock;
        lock.readLock().lock();
        try {
            if (entry.state == ConfigurationState.INITIAL) {
                this.loadConfiguration(tunnelId, entry);
            }
            TrustConfiguration trustConfiguration = entry.configuration;
            return trustConfiguration;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(String tunnelId, ConfigurationCacheEntry entry) {
        ReadWriteLock lock = entry.lock;
        lock.readLock().unlock();
        lock.writeLock().lock();
        try {
            if (entry.state == ConfigurationState.INITIAL) {
                entry.configuration = this.getSerializer().load(tunnelId);
            }
        }
        catch (TrustConfigurationException e) {
            log.error((Object)("Unable to load trust configuration for tunnel id " + tunnelId), (Throwable)e);
        }
        finally {
            entry.state = ConfigurationState.LOADED;
            lock.readLock().lock();
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfiguration(String tunnelId) throws TrustConfigurationException {
        ConfigurationCacheEntry entry = this.getCacheEntry(tunnelId);
        Lock writeLock = entry.lock.writeLock();
        writeLock.lock();
        try {
            this.getSerializer().delete(tunnelId);
            log.info((Object)MessageFormat.format("Successfully deleted IDP configuration for tunnel id ''{0}''", tunnelId));
        }
        finally {
            this.cache.remove(tunnelId);
            writeLock.unlock();
        }
        this.fireConfigurationChanged(TrustConfigurationServiceListener.TrustConfigurationChangeType.REMOVED);
    }

    public void enable(String tunnelId, int configurationId) throws TrustConfigurationException {
        this.doEnable(tunnelId, configurationId, true);
        log.info((Object)MessageFormat.format("Enabled IDP configuration with name ''{0}'' for tunnel id ''{1}''", configurationId, tunnelId));
        this.fireConfigurationChanged(TrustConfigurationServiceListener.TrustConfigurationChangeType.ENABLED);
    }

    public void disable(String tunnelId, int configurationId) throws TrustConfigurationException {
        this.doEnable(tunnelId, configurationId, false);
        log.info((Object)MessageFormat.format("Disabled IDP configuration with name ''{0}'' for tunnel id ''{1}''", configurationId, tunnelId));
        this.fireConfigurationChanged(TrustConfigurationServiceListener.TrustConfigurationChangeType.DISABLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnable(String tunnelId, int configurationId, boolean enabled) throws TrustConfigurationException {
        ConfigurationCacheEntry entry = this.getCacheEntry(tunnelId);
        if (entry.state == ConfigurationState.INITIAL) {
            this.getConfiguration(tunnelId);
        }
        ReadWriteLock lock = entry.lock;
        lock.readLock().lock();
        try {
            if (entry.configuration == null) {
                throw new TrustConfigurationException("No trust configuration found for tunnel id '" + tunnelId + "'");
            }
            this.writeEnabledState(tunnelId, entry, configurationId, enabled);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEnabledState(String tunnelId, ConfigurationCacheEntry entry, int configurationId, boolean enabled) throws TrustConfigurationException {
        ReadWriteLock lock = entry.lock;
        lock.readLock().unlock();
        lock.writeLock().lock();
        try {
            TrustConfiguration oldConfiguration = entry.configuration;
            ArrayList<IdentityProviderConfiguration> idpConfigurations = new ArrayList<IdentityProviderConfiguration>();
            for (IdentityProviderConfiguration oldIdpConfiguration : oldConfiguration.getIdPConfigurations()) {
                if (configurationId == oldIdpConfiguration.getId()) {
                    if (oldIdpConfiguration.isEnabled() == enabled) {
                        return;
                    }
                    idpConfigurations.add(new IdentityProviderConfiguration(oldIdpConfiguration, enabled));
                    continue;
                }
                idpConfigurations.add(oldIdpConfiguration);
            }
            ArrayList<ApplicationTrustConfiguration> appConfigurations = new ArrayList<ApplicationTrustConfiguration>();
            for (ApplicationTrustConfiguration oldAppConfiguration : oldConfiguration.getApplicationConfigurations()) {
                if (configurationId == oldAppConfiguration.getId()) {
                    if (oldAppConfiguration.isEnabled() == enabled) {
                        return;
                    }
                    appConfigurations.add(new ApplicationTrustConfiguration(oldAppConfiguration, enabled));
                    continue;
                }
                appConfigurations.add(oldAppConfiguration);
            }
            entry.configuration = new TrustConfiguration(oldConfiguration.getTunnelId(), new Date(), idpConfigurations, appConfigurations);
            this.getSerializer().persist(tunnelId, entry.configuration);
        }
        finally {
            entry.state = ConfigurationState.LOADED;
            lock.readLock().lock();
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustConfiguration synchronize(String tunnelId) throws TrustConfigurationException {
        ConfigurationCacheEntry entry = this.getCacheEntry(tunnelId);
        Lock writeLock = entry.lock.writeLock();
        writeLock.lock();
        try {
            log.info((Object)MessageFormat.format("Starting synchronization of IDP configuration for tunnel id ''{0}''", tunnelId));
            TrustConfiguration trustConfiguration = this.synchronizer.synchronize(tunnelId);
            TrustConfigurationMerger merger = new TrustConfigurationMerger();
            entry.configuration = merger.mergeConfigurations(entry.configuration, trustConfiguration);
            entry.state = ConfigurationState.LOADED;
            this.getSerializer().persist(tunnelId, entry.configuration);
            log.info((Object)MessageFormat.format("Successfully finished synchronization of IDP configuration for tunnel id ''{0}''", tunnelId));
            TrustConfiguration trustConfiguration2 = entry.configuration;
            return trustConfiguration2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private ConfigurationCacheEntry getCacheEntry(String tunnelId) {
        this.cache.putIfAbsent(tunnelId, new ConfigurationCacheEntry());
        return this.cache.get(tunnelId);
    }

    private TrustConfigurationSerializer getSerializer() {
        return (TrustConfigurationSerializer)this.serviceRegistry.getService(TrustConfigurationSerializer.class);
    }

    void addListener(TrustConfigurationServiceListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(TrustConfigurationServiceListener listener) {
        this.listeners.remove(listener);
    }

    private void fireConfigurationChanged(TrustConfigurationServiceListener.TrustConfigurationChangeType changeType) {
        for (TrustConfigurationServiceListener listener : this.listeners) {
            try {
                listener.configurationChanged(changeType);
            }
            catch (Exception e) {
                log.error((Object)"Error while invoking listener", (Throwable)e);
            }
        }
    }

    private class ConfigurationCacheEntry {
        private ConfigurationState state = ConfigurationState.INITIAL;
        private TrustConfiguration configuration;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

        private ConfigurationCacheEntry() {
        }
    }

    private static enum ConfigurationState {
        INITIAL,
        LOADED;

    }
}

