/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.client.sso;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.notification.sso.ApplicationTrustConfigurationData;
import com.sap.core.connectivity.tunnel.api.notification.sso.IdentityProviderConfigurationData;
import com.sap.core.connectivity.tunnel.api.notification.sso.TrustConfigurationData;
import com.sap.core.connectivity.tunnel.api.sso.ApplicationTrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.IdentityProviderConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfiguration;
import com.sap.core.connectivity.tunnel.api.sso.TrustConfigurationException;
import com.sap.core.connectivity.tunnel.client.notification.NotificationContextProvider;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.util.CertificateUtils;
import com.sap.core.connectivity.tunnel.core.util.XMLUtils;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TrustConfigurationSynchronizer {
    private final TunnelConfiguration tunnelConfiguration;
    private final ServiceRegistry serviceRegistry;

    public TrustConfigurationSynchronizer(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.tunnelConfiguration = (TunnelConfiguration)serviceRegistry.getService(TunnelConfiguration.class);
    }

    public TrustConfiguration synchronize(String tunnelId) throws TrustConfigurationException {
        try {
            Tunnel tunnel = this.getContext().getTunnelRegistry().getTunnel(tunnelId);
            TunnelRequestFuture future = tunnel.writeRequest(this.createTrustConfigurationRequest(tunnelId));
            if (!future.awaitUninterruptibly((long)this.tunnelConfiguration.getSSOConfigurationSynchronizationTimeoutInSeconds(), TimeUnit.SECONDS)) {
                future.cancel(true);
                throw new TrustConfigurationException(MessageFormat.format("Trust configuration was not received within {0} seconds", this.tunnelConfiguration.getSSOConfigurationSynchronizationTimeoutInSeconds()));
            }
            if (!future.isSuccess()) {
                throw new TrustConfigurationException("Unable to retrieve trust configuration", future.cause());
            }
            return this.parseResponse(tunnelId, future.response());
        }
        catch (NoChannelsAvailableException e) {
            throw new TrustConfigurationException("Unable to retrieve trust configuration", (Throwable)e);
        }
    }

    private MessagePacket createTrustConfigurationRequest(String tunnelId) {
        MessagePacket messagePacket = this.getContext().getMessagePacketFactory().createRequestPacket("notification", 6);
        messagePacket.setProperty("tunnelId", tunnelId);
        return messagePacket;
    }

    private TrustConfiguration parseResponse(String tunnelId, MessagePacket response) throws TrustConfigurationException {
        String errorMessage = response.getProperty("message");
        if (errorMessage != null) {
            throw new TrustConfigurationException(errorMessage);
        }
        try {
            String trustConfigurationAsString = response.getProperty("trustConfiguration");
            TrustConfigurationData trustConfigurationData = (TrustConfigurationData)XMLUtils.deserializeFromXml(TrustConfigurationData.class, (String)trustConfigurationAsString);
            ArrayList<IdentityProviderConfiguration> idpConfigurations = new ArrayList<IdentityProviderConfiguration>();
            for (IdentityProviderConfigurationData identityConfigurationData : trustConfigurationData.getIdpData()) {
                idpConfigurations.add(this.convertIdentityData(identityConfigurationData));
            }
            ArrayList<ApplicationTrustConfiguration> appConfigurations = new ArrayList<ApplicationTrustConfiguration>();
            for (ApplicationTrustConfigurationData appConfigurationData : trustConfigurationData.getApplicationData()) {
                appConfigurations.add(this.convertAppData(appConfigurationData));
            }
            return new TrustConfiguration(tunnelId, new Date(), idpConfigurations, appConfigurations);
        }
        catch (Exception e) {
            throw new TrustConfigurationException("Unable to retrieve trust configuration", (Throwable)e);
        }
    }

    private ApplicationTrustConfiguration convertAppData(ApplicationTrustConfigurationData appConfigurationData) {
        return new ApplicationTrustConfiguration(appConfigurationData.getAccount(), appConfigurationData.getName(), appConfigurationData.getApplicationType(), false);
    }

    private IdentityProviderConfiguration convertIdentityData(IdentityProviderConfigurationData identityConfigurationData) throws GeneralSecurityException, TrustConfigurationException {
        String base64EncodedCertificate = identityConfigurationData.getCertificate();
        X509Certificate certificate = null;
        if (base64EncodedCertificate != null) {
            certificate = CertificateUtils.extractCertificateFromBase64String((String)base64EncodedCertificate);
            return new IdentityProviderConfiguration(identityConfigurationData.getName(), identityConfigurationData.getDescription(), certificate, true);
        }
        String base64EncodedPublicKey = identityConfigurationData.getPublicKey();
        if (base64EncodedPublicKey != null) {
            return new IdentityProviderConfiguration(identityConfigurationData.getName(), identityConfigurationData.getDescription(), true, base64EncodedPublicKey);
        }
        throw new TrustConfigurationException("Identity Provider Configuration Data does not contain certificate nor public key");
    }

    private ConnectivityContext getContext() {
        return ((NotificationContextProvider)this.serviceRegistry.getService(NotificationContextProvider.class)).getNotificationContext();
    }
}

