/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import java.util.Set;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.ResourceRef;

abstract class AbstractKoteeDeployer
implements DynamicDeployer {
    protected static final String CONFIG_OBJECT_FACTORY = "com.sap.cloud.runtime.kotee.deployer.object_factory";
    protected static final String DEFAULT_OBJECT_FACTORY = "com.sap.cloud.runtime.kotyo.tomcat.support.DelegatingObjectFactory";
    protected static final String PROPERTY_REFERENCE = "reference";
    protected static final String PROPERTY_FACTORY = "factory";
    protected static final String PROPERTY_APP_NAME = "appName";
    protected static final String PROPERTY_MAPPED_NAME = "mappedName";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PROPERTY_LAZY = "LAZY";
    protected static final String PROPERTY_RESOURCE_REF_NAME = "ResourceRefName";

    AbstractKoteeDeployer() {
    }

    protected Resource findResource(AppModule appModule, String resourceId) {
        for (Resource resource : appModule.getResources()) {
            if (!resourceId.equals(resource.getId())) continue;
            return resource;
        }
        return null;
    }

    protected String getWebModuleId(WebModule webModule) {
        String host = webModule.getHost();
        String contextRoot = webModule.getContextRoot();
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return host + contextRoot;
    }

    protected String normalizeName(String resName) {
        String name = resName;
        if (name.startsWith("java:")) {
            name = name.substring("java:".length());
        }
        if (name.startsWith("comp/env/")) {
            name = name.substring("comp/env/".length());
        }
        return name;
    }

    protected String getResourceName(String resourceRefName) {
        String name = resourceRefName;
        int subContextIndex = resourceRefName.lastIndexOf(47);
        if (subContextIndex >= 0) {
            name = name.substring(subContextIndex + 1);
        }
        return name;
    }

    protected String printResource(Resource resource) {
        String text = "Resource[Id=" + resource.getId() + ", " + "ClassName=" + resource.getClassName() + ", " + "Constructor=" + resource.getConstructor() + ", " + "ClassPath=" + resource.getClasspath() + ", " + "FactoryName=" + resource.getFactoryName() + ", " + "JAR=" + resource.getJar() + ", " + "Jndi=" + resource.getJndi() + ", " + "Type=" + resource.getType() + ", " + "PostConstruct=" + resource.getPostConstruct() + ", " + "PreDestroy=" + resource.getPreDestroy() + ", " + "PropertiesProvider=" + resource.getPropertiesProvider() + ", " + "Provider=" + resource.getProvider() + ", " + "Properties=" + resource.getProperties() + "]";
        return text;
    }

    protected String printResourceRef(ResourceRef resourceRef) {
        String text = "ResourceRef[Id=" + resourceRef.getId() + ", " + "Key=" + resourceRef.getKey() + ", " + "Type=" + resourceRef.getType() + ", " + "ResType=" + resourceRef.getResType() + ", " + "ResRefName=" + resourceRef.getResRefName() + ", " + "LookUpName=" + resourceRef.getLookupName() + ", " + "MappedName=" + resourceRef.getMappedName() + ", " + "Name=" + resourceRef.getName() + ", " + "Origin=" + resourceRef.getOrigin() + ", " + "ResAuth=" + resourceRef.getResAuth() + ", " + "ResSharingScope=" + resourceRef.getResSharingScope() + ", " + "InjectionTargets=" + this.printInjectionTargets(resourceRef) + "]";
        return text;
    }

    private String printInjectionTargets(ResourceRef resourceRef) {
        Set injectionTargets = resourceRef.getInjectionTarget();
        if (null == injectionTargets || injectionTargets.isEmpty()) {
            return "[]";
        }
        String targets = "[";
        for (InjectionTarget injectionTarget : injectionTargets) {
            targets = targets + "class=" + injectionTarget.getInjectionTargetClass() + ", name=" + injectionTarget.getInjectionTargetName() + "; ";
        }
        targets = targets + "]";
        return targets;
    }
}

