/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import com.sap.cloud.runtime.kotee.deployer.AbstractKoteeDeployer;
import com.sap.cloud.runtime.kotee.deployer.CreationStrategy;
import com.sap.cloud.runtime.kotee.deployer.DataSourceType;
import com.sap.cloud.runtime.kotee.deployer.ResourceDeployer;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.sys.Resource;

final class CtsDataSourceDeployer
extends AbstractKoteeDeployer {
    private static final Logger logger = Logger.getLogger(ResourceDeployer.class.getName());
    private static final String JDBC_DEFAULT_MANAGED_CTS_DATA_SOURCE = "jdbc/DB1";
    private static final String JDBC_DEFAULT_UNMANAGED_CTS_DATA_SOURCE = "jdbc/DB_no_tx";
    private static final String PROPERTY_JTA_MANAGED = "JtaManaged";
    private static final String PROPERTY_TRANSACTION_TYPE = "transactionType";
    private static final String TRANSACTION_TYPE_NON_TRANSACTIONAL = "non-transactional";
    private static final String TYPE_DATASOURCE_FULL = "javax.sql.DataSource";
    private static final String PROPERTY_MAX_WAIT_TIME = "MaxWaitTime";
    private static final String DEFAULT_MAX_WAIT_TIME = "10000";
    private static final String PROPERTY_DS_USERNAME = "UserName";
    private static final String DEFAULT_DS_USERNAME = "cts1";
    private static final String PROPERTY_DS_PASSWORD = "Password";
    private static final String DEFAULT_DS_PASSWORD = "cts1";
    private static final String PROPERTY_JDBC_DRIVER = "JdbcDriver";
    private static final String DEFAULT_JDBC_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    private static final String PROPERTY_JDBC_URL = "JdbcUrl";
    private static final String DEFAULT_JDBC_URL = "jdbc:derby://localhost:1527/derbyDB";

    CtsDataSourceDeployer() {
    }

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        try {
            this.createDefaultCtsDataSources(appModule);
        }
        catch (Exception ex) {
            throw new OpenEJBException("Failed to perform DataSource configuration for AppModule '" + appModule.getModuleId() + "':", (Throwable)ex);
        }
        return appModule;
    }

    private void createDefaultCtsDataSources(AppModule appModule) throws InvalidNameException {
        this.createDataSource(appModule, JDBC_DEFAULT_MANAGED_CTS_DATA_SOURCE, CreationStrategy.LAZY, DataSourceType.JTA);
        this.createDataSource(appModule, JDBC_DEFAULT_UNMANAGED_CTS_DATA_SOURCE, CreationStrategy.LAZY, DataSourceType.NON_JTA);
    }

    private void createDataSource(AppModule appModule, String resourceId, CreationStrategy creationStrategy, DataSourceType type) throws InvalidNameException {
        Properties properties = new Properties();
        if (CreationStrategy.EAGER.equals((Object)creationStrategy)) {
            properties.setProperty("LAZY", Boolean.FALSE.toString());
        } else if (CreationStrategy.LAZY.equals((Object)creationStrategy)) {
            properties.setProperty("LAZY", Boolean.TRUE.toString());
        } else {
            throw new IllegalArgumentException("Unexpected creation strategy: " + (Object)((Object)creationStrategy));
        }
        if (DataSourceType.JTA.equals((Object)type)) {
            properties.setProperty(PROPERTY_JTA_MANAGED, Boolean.TRUE.toString());
        } else if (DataSourceType.NON_JTA.equals((Object)type)) {
            properties.setProperty(PROPERTY_JTA_MANAGED, Boolean.FALSE.toString());
            properties.setProperty(PROPERTY_TRANSACTION_TYPE, TRANSACTION_TYPE_NON_TRANSACTIONAL);
        } else {
            throw new IllegalArgumentException("Unexpected DataSource type: " + (Object)((Object)type));
        }
        this.createDataSource(appModule, resourceId, properties);
    }

    private void createDataSource(AppModule appModule, String resourceId, Properties config) throws InvalidNameException {
        Resource resource = new Resource(resourceId);
        resource.setType(TYPE_DATASOURCE_FULL);
        resource.setProvider("com.sap.cloud.runtime.kotee.deployer:KoteeDataSourceProvider");
        Properties properties = resource.getProperties();
        properties.putAll((Map<?, ?>)config);
        properties.setProperty("factory", "com.sap.cloud.runtime.kotyo.tomcat.support.DelegatingObjectFactory");
        properties.setProperty("appName", appModule.getModuleId());
        properties.setProperty(PROPERTY_MAX_WAIT_TIME, DEFAULT_MAX_WAIT_TIME);
        properties.setProperty(PROPERTY_DS_USERNAME, "cts1");
        properties.setProperty(PROPERTY_DS_PASSWORD, "cts1");
        properties.setProperty(PROPERTY_JDBC_DRIVER, DEFAULT_JDBC_DRIVER);
        properties.setProperty(PROPERTY_JDBC_URL, DEFAULT_JDBC_URL);
        CompositeName name = new CompositeName(resourceId);
        properties.put("name", name);
        Reference reference = new Reference(TYPE_DATASOURCE_FULL);
        properties.put("reference", reference);
        for (Object key : config.keySet()) {
            if (!(key instanceof String)) {
                logger.log(Level.SEVERE, "The property key '" + key + "' is not a java.lang.String, but a '" + key.getClass() + "'");
                continue;
            }
            String propertyKey = (String)key;
            this.addProperty(reference, propertyKey, config.getProperty(propertyKey));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding javax.sql.DataSource resource definition '" + resourceId + "' to module '" + appModule.getModuleId() + "' with configuration '" + config + "'");
        }
        appModule.getResources().add(resource);
    }

    private void addProperty(Reference reference, String key, String value) {
        StringRefAddr property = new StringRefAddr(key, value);
        reference.add(property);
    }
}

