/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import com.sap.cloud.runtime.kotee.deployer.AbstractKoteeDeployer;
import com.sap.cloud.runtime.kotee.deployer.ConfigurationProvider;
import com.sap.cloud.runtime.kotee.deployer.CreationStrategy;
import com.sap.cloud.runtime.kotee.deployer.DataSourceType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;

final class DataSourceDeployer
extends AbstractKoteeDeployer {
    private static final Logger logger = Logger.getLogger(DataSourceDeployer.class.getName());
    static final String CONFIG_REGISTER_DEFAULT_DS = "com.sap.cloud.runtime.kotee.deployer.register_default_datasources";
    static final String CONFIG_DATA_SOURCE_PROVIDER = "com.sap.cloud.runtime.kotee.deployer.data_source_provider";
    static final String DEFAULT_DATASOURCE_PROVIDER = "com.sap.cloud.runtime.kotee.deployer:KoteeDataSourceProvider";
    static final String JDBC_DEFAULT_UNMANAGED_DATA_SOURCE = "jdbc/defaultUnmanagedDataSource";
    static final String JDBC_DEFAULT_MANAGED_DATA_SOURCE = "jdbc/defaultManagedDataSource";
    static final String PROPERTY_CREATED_BY = "created-by";
    static final String PROPERTY_JTA_MANAGED = "JtaManaged";
    static final String PROPERTY_TRANSACTION_TYPE = "transactionType";
    static final String TRANSACTION_TYPE_NON_TRANSACTIONAL = "non-transactional";
    static final String TYPE_DATASOURCE_SHORT = "DataSource";
    static final String TYPE_DATASOURCE_FULL = "javax.sql.DataSource";
    private final ConfigurationProvider configurationProvider;

    public DataSourceDeployer(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        try {
            this.processDataSourceReferences(appModule);
            if (this.shouldRegisterDefaultDataSources()) {
                this.createDefaultDataSources(appModule);
            }
            this.processPersistenceModules(appModule);
        }
        catch (Exception ex) {
            String moduleId = appModule.getModuleId();
            throw new OpenEJBException("Failed to perform DataSource configuration for AppModule '" + moduleId + "':", (Throwable)ex);
        }
        return appModule;
    }

    private void processDataSourceReferences(AppModule appModule) throws InvalidNameException {
        List webModules = appModule.getWebModules();
        if (null != webModules) {
            for (WebModule webModule : webModules) {
                WebApp webApp = webModule.getWebApp();
                Collection resourceRefs = webApp.getResourceRef();
                for (ResourceRef resourceRef : resourceRefs) {
                    this.processResourceRef(appModule, webModule, resourceRef);
                }
            }
        }
    }

    private void processResourceRef(AppModule appModule, WebModule webModule, ResourceRef resourceRef) throws InvalidNameException {
        String resType = resourceRef.getResType();
        if (TYPE_DATASOURCE_FULL.equals(resType) || TYPE_DATASOURCE_SHORT.equals(resType)) {
            String resourceRefName = this.normalizeName(resourceRef.getResRefName());
            String mappedName = resourceRef.getMappedName();
            String name = resourceRefName;
            if (mappedName != null) {
                name = this.normalizeName(mappedName);
            }
            if (!this.resourceExists(appModule, name)) {
                this.createDataSourceForWebModule(appModule, webModule, CreationStrategy.EAGER, null, name);
            } else if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Resource with ID='" + name + "' already exists " + "in AppModule '" + appModule.getModuleId() + "' " + "\nResource definition: " + this.printResource(this.findResource(appModule, name)) + "\nResourceRef: [" + resourceRef + "]");
            }
        }
    }

    private void createDefaultDataSources(AppModule appModule) throws InvalidNameException {
        List webModules = appModule.getWebModules();
        if (webModules.isEmpty()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Skipping default data source configuration for AppModule '" + appModule.getModuleId() + "' " + "with path '" + appModule.getModuleUri() + "' " + "because it does not have any web modules!");
            }
            return;
        }
        if (webModules.size() > 1 && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "The app module '" + appModule.getModuleId() + "' " + "contains more than one web module. ");
        }
        WebModule webModule = (WebModule)webModules.get(0);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Registering default data sources to web module '" + webModule.getModuleId() + "' " + "with path '" + webModule.getModuleUri() + "'");
        }
        if (this.resourceExists(appModule, JDBC_DEFAULT_MANAGED_DATA_SOURCE)) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Resource with id 'jdbc/defaultManagedDataSource' already exists.");
            }
        } else {
            this.createDataSourceForWebModule(appModule, webModule, CreationStrategy.LAZY, DataSourceType.JTA, JDBC_DEFAULT_MANAGED_DATA_SOURCE);
        }
        if (this.resourceExists(appModule, JDBC_DEFAULT_UNMANAGED_DATA_SOURCE)) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Resource with id 'jdbc/defaultUnmanagedDataSource' already exists.");
            }
        } else {
            this.createDataSourceForWebModule(appModule, webModule, CreationStrategy.LAZY, DataSourceType.NON_JTA, JDBC_DEFAULT_UNMANAGED_DATA_SOURCE);
        }
    }

    private boolean shouldRegisterDefaultDataSources() {
        String value = this.configurationProvider.getConfiguration(CONFIG_REGISTER_DEFAULT_DS, Boolean.TRUE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    private void processPersistenceModules(AppModule appModule) throws InvalidNameException {
        List persistenceModules = appModule.getPersistenceModules();
        for (PersistenceModule persistenceModule : persistenceModules) {
            this.processPersistenceModule(appModule, persistenceModule);
        }
    }

    private void processPersistenceModule(AppModule appModule, PersistenceModule persistenceModule) throws InvalidNameException {
        Persistence persistence = persistenceModule.getPersistence();
        List persistenceUnits = persistence.getPersistenceUnit();
        for (PersistenceUnit persistenceUnit : persistenceUnits) {
            this.processPersistenceUnit(appModule, persistenceModule, persistenceUnit);
        }
    }

    private void processPersistenceUnit(AppModule appModule, PersistenceModule persistenceModule, PersistenceUnit persistenceUnit) throws InvalidNameException {
        String nonJtaDataSource;
        String jtaDataSource = persistenceUnit.getJtaDataSource();
        if (null != jtaDataSource) {
            this.handleDataSourceFromPersistenceUnit(appModule, persistenceModule, DataSourceType.JTA, jtaDataSource);
        }
        if (null != (nonJtaDataSource = persistenceUnit.getNonJtaDataSource())) {
            this.handleDataSourceFromPersistenceUnit(appModule, persistenceModule, DataSourceType.NON_JTA, nonJtaDataSource);
        }
    }

    private void handleDataSourceFromPersistenceUnit(AppModule appModule, PersistenceModule persistenceModule, DataSourceType type, String dataSourceId) throws InvalidNameException {
        String resourceId = this.normalizeName(dataSourceId);
        if (this.isGlobal(resourceId)) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Skipping configuration for global " + (Object)((Object)type) + " data source " + "with id '" + resourceId + "' " + "in persistence module '" + persistenceModule.getModuleId() + "' " + "in app module '" + appModule.getModuleId() + "'");
            }
            return;
        }
        Resource resource = this.findResource(appModule, resourceId);
        if (null == resource) {
            this.createDataSourceForPersistenceUnit(appModule, persistenceModule, type, dataSourceId);
        } else {
            this.updateDataSourceDefinition(resource, type);
        }
    }

    private boolean isGlobal(String dataSourceName) {
        if (dataSourceName.startsWith("openejb:")) {
            return true;
        }
        if (dataSourceName.startsWith("openejb/Resource")) {
            return true;
        }
        return dataSourceName.startsWith("java:openejb/Resource/");
    }

    private void createDataSourceForPersistenceUnit(AppModule appModule, PersistenceModule persistenceModule, DataSourceType type, String dataSourceId) throws InvalidNameException {
        WebModule webModule = this.findCorrespondingWebModule(appModule, persistenceModule);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Creating " + (Object)((Object)type) + " data source " + "with name " + dataSourceId + " for web module " + (webModule != null ? webModule.getModuleId() : null));
        }
        this.createDataSourceForWebModule(appModule, webModule, CreationStrategy.EAGER, type, dataSourceId);
    }

    private WebModule findCorrespondingWebModule(AppModule appModule, PersistenceModule persistenceModule) {
        String persistenceModulePath = persistenceModule.getModuleUri().normalize().getPath();
        if (null == persistenceModulePath) {
            return null;
        }
        List webModules = appModule.getWebModules();
        for (WebModule webModule : webModules) {
            String webModulePath = webModule.getModuleUri().normalize().getPath();
            if (null == webModulePath || !persistenceModulePath.startsWith(webModulePath)) continue;
            return webModule;
        }
        return null;
    }

    private void updateDataSourceDefinition(Resource resource, DataSourceType dataSourceType) {
        Properties properties = resource.getProperties();
        if (!DataSourceDeployer.class.getName().equals(properties.getProperty(PROPERTY_CREATED_BY))) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "The resource for data source '" + resource.getId() + "' " + "was not created by the " + DataSourceDeployer.class.getName() + " " + "hence will not update the resource definition with properties from " + "the persistence unit definition.");
            }
            return;
        }
        if (!DataSource.class.getName().equals(resource.getType())) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Cannot update resource definition for " + this.printResource(resource) + " because it's not a " + DataSource.class.getName());
            }
            return;
        }
        String isJta = properties.getProperty(PROPERTY_JTA_MANAGED);
        if (null != isJta) {
            if (DataSourceType.JTA.equals((Object)dataSourceType) && Boolean.FALSE.toString().equalsIgnoreCase(isJta)) {
                throw new IllegalStateException("DataSource with name '" + resource.getId() + "' " + "is already configured to be NON-JTA DS.");
            }
            if (DataSourceType.NON_JTA.equals((Object)dataSourceType) && Boolean.TRUE.toString().equalsIgnoreCase(isJta)) {
                throw new IllegalStateException("DataSource with name '" + resource.getId() + "' " + "is already configured to be JTA DS.");
            }
        } else {
            this.configureDataSourceType(properties, dataSourceType);
            Reference reference = this.buildReferenceFromProperties(properties);
            this.addProperty(reference, "ResourceRefName", resource.getId());
            properties.put("reference", reference);
        }
    }

    private boolean resourceExists(AppModule appModule, String resourceId) {
        return null != this.findResource(appModule, resourceId);
    }

    private void createDataSourceForWebModule(AppModule appModule, WebModule webModule, CreationStrategy creationStrategy, DataSourceType dataSourceType, String resourceId) throws InvalidNameException {
        Properties properties = new Properties();
        this.configureCreationStrategy(properties, creationStrategy);
        this.configureDataSourceType(properties, dataSourceType);
        if (null != webModule) {
            String webModuleId = this.getWebModuleId(webModule);
            properties.put("appName", webModuleId);
        }
        this.createDataSource(appModule, properties, resourceId);
    }

    private void configureCreationStrategy(Properties properties, CreationStrategy creationStrategy) {
        if (CreationStrategy.EAGER.equals((Object)creationStrategy)) {
            properties.setProperty("LAZY", Boolean.FALSE.toString());
        } else if (CreationStrategy.LAZY.equals((Object)creationStrategy)) {
            properties.setProperty("LAZY", Boolean.TRUE.toString());
        } else {
            throw new IllegalArgumentException("Unexpected creation strategy: " + (Object)((Object)creationStrategy));
        }
    }

    private void configureDataSourceType(Properties properties, DataSourceType dataSourceType) {
        boolean isJtaManaged;
        if (DataSourceType.JTA.equals((Object)dataSourceType)) {
            isJtaManaged = true;
        } else if (DataSourceType.NON_JTA.equals((Object)dataSourceType)) {
            isJtaManaged = false;
        } else {
            if (null != dataSourceType) {
                throw new IllegalArgumentException("Unexpected DataSource type: " + (Object)((Object)dataSourceType));
            }
            return;
        }
        Object oldValue = properties.setProperty(PROPERTY_JTA_MANAGED, Boolean.toString(isJtaManaged));
        if (null != oldValue && logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Overriding value for property 'JtaManaged' \tOld value: '" + oldValue + "' " + "\tNew value: " + isJtaManaged);
        }
        if (isJtaManaged) {
            properties.remove(PROPERTY_TRANSACTION_TYPE);
        } else {
            properties.setProperty(PROPERTY_TRANSACTION_TYPE, TRANSACTION_TYPE_NON_TRANSACTIONAL);
        }
    }

    private void createDataSource(AppModule appModule, Properties config, String resourceId) throws InvalidNameException {
        Resource resource = new Resource(resourceId);
        resource.setType(TYPE_DATASOURCE_FULL);
        resource.setProvider(this.configurationProvider.getConfiguration(CONFIG_DATA_SOURCE_PROVIDER, DEFAULT_DATASOURCE_PROVIDER));
        Properties properties = resource.getProperties();
        properties.putAll((Map<?, ?>)config);
        if (null == properties.getProperty("appName") && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "The property 'appName' is not present for " + this.printResource(resource));
        }
        properties.setProperty("factory", this.configurationProvider.getConfiguration("com.sap.cloud.runtime.kotee.deployer.object_factory", "com.sap.cloud.runtime.kotyo.tomcat.support.DelegatingObjectFactory"));
        properties.setProperty(PROPERTY_CREATED_BY, DataSourceDeployer.class.getName());
        CompositeName name = new CompositeName(this.getResourceName(resourceId));
        properties.put("name", name);
        Reference reference = this.buildReferenceFromProperties(properties);
        this.addProperty(reference, "ResourceRefName", resourceId);
        properties.put("reference", reference);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding javax.sql.DataSource resource definition '" + resourceId + "' to module '" + appModule.getModuleId() + "' with configuration '" + config + "'");
        }
        appModule.getResources().add(resource);
    }

    private Reference buildReferenceFromProperties(Properties properties) {
        Reference reference = new Reference(TYPE_DATASOURCE_FULL);
        if (properties.containsKey(PROPERTY_JTA_MANAGED)) {
            this.addProperty(reference, PROPERTY_JTA_MANAGED, properties.getProperty(PROPERTY_JTA_MANAGED));
        }
        if (properties.containsKey(PROPERTY_TRANSACTION_TYPE)) {
            this.addProperty(reference, PROPERTY_TRANSACTION_TYPE, properties.getProperty(PROPERTY_TRANSACTION_TYPE));
        }
        return reference;
    }

    private void addProperty(Reference reference, String key, String value) {
        StringRefAddr property = new StringRefAddr(key, value);
        reference.add(property);
    }
}

