/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import com.sap.cloud.runtime.kotee.deployer.ConfigurationProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;

final class DynamicDeployerProxy
implements DynamicDeployer {
    private static final Logger logger = Logger.getLogger(DynamicDeployerProxy.class.getName());
    private static final String CONFIG_DSABLE_FOR_MODULES = "com.sap.cloud.runtime.kotee.deployer.disable_for_modules";
    private static final String MODULE_ID_SEPARATOR = ";";
    private final Set<String> blacklistedModuleIds;
    private final ConfigurationProvider configurationProvider;
    private final DynamicDeployer delegate;

    public DynamicDeployerProxy(DynamicDeployer deployer, ConfigurationProvider configurationProvider) {
        this.delegate = deployer;
        this.configurationProvider = configurationProvider;
        this.blacklistedModuleIds = new HashSet<String>(3);
        this.initTheModuleIdBlacklist();
    }

    private void initTheModuleIdBlacklist() {
        String modulesBlackList = this.configurationProvider.getConfiguration(CONFIG_DSABLE_FOR_MODULES);
        if (null != modulesBlackList) {
            String[] blacklistedModules;
            for (String module : blacklistedModules = modulesBlackList.split(MODULE_ID_SEPARATOR)) {
                String moduleId = module.trim();
                if (moduleId.isEmpty()) continue;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Adding module '" + moduleId + "' to the deployer blacklist.");
                }
                this.blacklistedModuleIds.add(moduleId);
            }
        }
    }

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        String moduleId = appModule.getModuleId();
        if (this.blacklistedModuleIds.contains(moduleId)) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Skipping configuration for AppModule '" + moduleId + "' because it was in the blacklist");
            }
            return appModule;
        }
        return this.delegate.deploy(appModule);
    }
}

