/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import com.sap.cloud.runtime.kotee.deployer.ConfigurationProvider;
import com.sap.cloud.runtime.kotee.deployer.CtsDataSourceDeployer;
import com.sap.cloud.runtime.kotee.deployer.DataSourceDeployer;
import com.sap.cloud.runtime.kotee.deployer.DelegatingDeployer;
import com.sap.cloud.runtime.kotee.deployer.DynamicDeployerProxy;
import com.sap.cloud.runtime.kotee.deployer.ResourceDeployer;
import com.sap.cloud.runtime.kotee.deployer.SystemConfigurationProvider;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AutoConfig;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DynamicDeployer;

public final class EnhancedConfigurationFactory
extends ConfigurationFactory {
    private static final Logger logger = Logger.getLogger(EnhancedConfigurationFactory.class.getName());
    private static final String CONFIG_REGISTER_DEFAULT_CTS_DS = "com.sap.cloud.runtime.kotee.deployer.register_default_cts_datasources";
    private static final boolean IS_OFFLINE = false;

    public EnhancedConfigurationFactory() throws OpenEJBException {
        super(false, EnhancedConfigurationFactory.initPreAutoConfigDeployers());
        EnhancedConfigurationFactory.reorderDeployers(this);
    }

    private static DynamicDeployer initPreAutoConfigDeployers() throws OpenEJBException {
        ConfigurationProvider configurationProvider = EnhancedConfigurationFactory.loadConfigurationProvider();
        DelegatingDeployer deployer = new DelegatingDeployer();
        deployer.addDeployer(new ResourceDeployer(configurationProvider));
        deployer.addDeployer(new DataSourceDeployer(configurationProvider));
        if (EnhancedConfigurationFactory.shouldRegisterDefaultCtsDataSources(configurationProvider)) {
            deployer.addDeployer(new CtsDataSourceDeployer());
        }
        return new DynamicDeployerProxy(deployer, configurationProvider);
    }

    private static ConfigurationProvider loadConfigurationProvider() throws OpenEJBException {
        try {
            ConfigurationProvider configurationProvider;
            String configurationProviderClassName = System.getProperty(ConfigurationProvider.class.getName());
            if (null == configurationProviderClassName) {
                configurationProvider = new SystemConfigurationProvider();
            } else {
                Class<?> configurationProviderClass = Class.forName(configurationProviderClassName);
                if (!ConfigurationProvider.class.isAssignableFrom(configurationProviderClass)) {
                    throw new OpenEJBException("The provided configuration provider '" + configurationProviderClassName + "' is not an instance of '" + ConfigurationProvider.class + "'");
                }
                configurationProvider = (ConfigurationProvider)configurationProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return configurationProvider;
        }
        catch (ReflectiveOperationException ex) {
            throw new OpenEJBException((Throwable)ex);
        }
    }

    private static void reorderDeployers(ConfigurationFactory configurationFactory) throws OpenEJBException {
        try {
            EnhancedConfigurationFactory.doReorderDeployers(configurationFactory);
        }
        catch (Exception ex) {
            throw new OpenEJBException("Failed to configure the deployer chain.", (Throwable)ex);
        }
    }

    private static void doReorderDeployers(ConfigurationFactory configurationFactory) throws ReflectiveOperationException {
        ConfigurationFactory.Chain chain = EnhancedConfigurationFactory.getDeployerChain(configurationFactory);
        List<DynamicDeployer> deployers = EnhancedConfigurationFactory.getDynamicDeployers(chain);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINE, "Deployer chain before reordering: " + EnhancedConfigurationFactory.printDeployerChain(deployers));
        }
        boolean reordered = false;
        DynamicDeployer preAutoConfigDeployer = null;
        ListIterator<DynamicDeployer> deployerIterator = deployers.listIterator();
        while (deployerIterator.hasNext()) {
            DynamicDeployer deployer = deployerIterator.next();
            if (deployer instanceof DynamicDeployerProxy || deployer instanceof DelegatingDeployer) {
                if (null != preAutoConfigDeployer) {
                    throw new IllegalStateException("Unexpected second instance of pre-AutoConfig deployer: " + preAutoConfigDeployer.getClass());
                }
                preAutoConfigDeployer = deployer;
                deployerIterator.remove();
                continue;
            }
            if (!(deployer instanceof AutoConfig)) continue;
            if (null == preAutoConfigDeployer) {
                throw new IllegalStateException("The pre-AutoConfig deployer is not present in the deployer chain");
            }
            deployerIterator.previous();
            deployerIterator.add(preAutoConfigDeployer);
            reordered = true;
            break;
        }
        if (!reordered) {
            throw new IllegalStateException("Failed to reorder the deployer chain -> no AutoConfig deployer was found.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINE, "Deployer chain after reordering: " + EnhancedConfigurationFactory.printDeployerChain(deployers));
        }
    }

    private static ConfigurationFactory.Chain getDeployerChain(ConfigurationFactory configurationFactory) throws ReflectiveOperationException {
        Field deployerChain = ConfigurationFactory.class.getDeclaredField("deployer");
        deployerChain.setAccessible(true);
        Object chainObject = deployerChain.get(configurationFactory);
        if (null == chainObject) {
            throw new IllegalStateException("The deployer chain has not been initialized yet.");
        }
        if (!ConfigurationFactory.Chain.class.isAssignableFrom(chainObject.getClass())) {
            throw new IllegalStateException("This configuration factory is incompatible with the current TomEE version. Expected: " + ConfigurationFactory.Chain.class + " " + "Actual: " + chainObject.getClass());
        }
        return (ConfigurationFactory.Chain)chainObject;
    }

    private static List<DynamicDeployer> getDynamicDeployers(ConfigurationFactory.Chain chain) throws ReflectiveOperationException {
        Field chainCollection = ConfigurationFactory.Chain.class.getDeclaredField("chain");
        chainCollection.setAccessible(true);
        Object chainObject = chainCollection.get(chain);
        if (null == chainObject) {
            throw new IllegalStateException("The deployer chain collection is null!");
        }
        if (!List.class.isAssignableFrom(chainObject.getClass())) {
            throw new IllegalStateException("This configuration factory is incompatible with the current TomEE version. Expected: " + List.class + " " + "Actual: " + chainObject.getClass());
        }
        return (List)chainObject;
    }

    private static String printDeployerChain(List<DynamicDeployer> deployers) {
        StringBuilder stringBuilder = new StringBuilder(deployers.size() * 64);
        stringBuilder.append("DeployerChain[");
        for (DynamicDeployer deployer : deployers) {
            stringBuilder.append(deployer.getClass());
            stringBuilder.append(";");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static boolean shouldRegisterDefaultCtsDataSources(ConfigurationProvider configurationProvider) {
        String value = configurationProvider.getConfiguration(CONFIG_REGISTER_DEFAULT_CTS_DS, Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }
}

