/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.TomcatWebAppBuilder;

public final class KoteeServiceProvider {
    private static final Logger logger = Logger.getLogger(KoteeServiceProvider.class.getName());
    private Reference reference;
    private Name name;
    private Hashtable<?, ?> environment;
    private Context nameCtx;
    private String factory;
    private String appName;

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setEnvironment(Hashtable<?, ?> environment) {
        this.environment = environment;
    }

    public void setNameCtx(Context nameCtx) {
        this.nameCtx = nameCtx;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject() throws Exception {
        ClassLoader selectedClassLoader;
        if (null == this.factory) {
            throw new IllegalStateException("The factory was not set. Cannot create resources without a valid factory.");
        }
        TomcatWebAppBuilder webAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
        if (null == webAppBuilder) {
            throw new IllegalStateException("The WebAppBuilder is not initialized.");
        }
        ClassLoader originalThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader webModuleClassLoader = this.getWebModuleClassLoader(webAppBuilder);
        ClassLoader classLoader = selectedClassLoader = null != webModuleClassLoader ? webModuleClassLoader : originalThreadContextClassLoader;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Using '" + selectedClassLoader + "' classloader for resource with name '" + this.name + "'");
        }
        Thread.currentThread().setContextClassLoader(selectedClassLoader);
        try {
            Class<?> clazz = selectedClassLoader.loadClass(this.factory);
            if (!ObjectFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("Unexpected factory class: " + clazz + ". It must be instance of: " + ObjectFactory.class.getName());
            }
            Object factoryInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Object object = ((ObjectFactory)factoryInstance).getObjectInstance(this.reference, this.name, this.nameCtx, this.environment);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalThreadContextClassLoader);
        }
    }

    private ClassLoader getWebModuleClassLoader(TomcatWebAppBuilder webAppBuilder) {
        if (null == this.appName) {
            return null;
        }
        TomcatWebAppBuilder.ContextInfo info = webAppBuilder.getContextInfo(this.appName);
        if (info == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "There is no ContextInfo for appName: " + this.appName + "; default classloader will be used");
            }
            return null;
        }
        if (null == info.standardContext) {
            throw new IllegalStateException("There is no StandardContext available for: " + this.appName);
        }
        return info.standardContext.getLoader().getClassLoader();
    }
}

