/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotee.deployer;

import com.sap.cloud.runtime.kotee.deployer.AbstractKoteeDeployer;
import com.sap.cloud.runtime.kotee.deployer.ConfigurationProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.ResourceRef;

final class ResourceDeployer
extends AbstractKoteeDeployer {
    private static final Logger logger = Logger.getLogger(ResourceDeployer.class.getName());
    static final String CONFIG_RESOURCE_PROVIDER = "com.sap.cloud.runtime.kotee.deployer.resource_provider";
    static final String DEFAULT_RESOURCE_PROVIDER = "com.sap.cloud.runtime.kotee.deployer:KoteeResourceProvider";
    static final String CONFIG_RESOURCE_DEPLOYER_WHITELIST = "com.sap.cloud.runtime.kotee.deployer.resource_whitelist";
    static final String CONFIG_RESOURCE_DEPLOYER_BLACKLIST = "com.sap.cloud.runtime.kotee.deployer.resource_blacklist";
    static final String SEPARATOR = ";";
    private final Collection<String> resourceWhiteList;
    private final Collection<String> resourceBlackList;
    private final ConfigurationProvider configurationProvider;

    public ResourceDeployer(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        this.resourceWhiteList = new HashSet<String>();
        this.resourceBlackList = new HashSet<String>();
        this.initResourceWhiteList();
        this.initResourceBlackList();
    }

    private void initResourceWhiteList() {
        this.populateFromConfiguration(this.resourceWhiteList, CONFIG_RESOURCE_DEPLOYER_WHITELIST, "white-list");
    }

    private void initResourceBlackList() {
        this.populateFromConfiguration(this.resourceBlackList, CONFIG_RESOURCE_DEPLOYER_BLACKLIST, "black-list");
    }

    private void populateFromConfiguration(Collection<String> collection, String propertyName, String collectionName) {
        String values = this.configurationProvider.getConfiguration(propertyName);
        if (null != values) {
            String[] splittedValues;
            for (String value : splittedValues = values.split(SEPARATOR)) {
                String trimmedValue = value.trim();
                if (trimmedValue.isEmpty()) continue;
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Adding value '" + trimmedValue + "' to the " + collectionName);
                }
                collection.add(value);
            }
        }
    }

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        try {
            for (WebModule webModule : appModule.getWebModules()) {
                this.processWebModuleResources(webModule, appModule);
            }
        }
        catch (Exception ex) {
            throw new OpenEJBException("Failed to perform resource configuration for AppModule '" + appModule.getModuleId() + "':", (Throwable)ex);
        }
        return appModule;
    }

    private void processWebModuleResources(WebModule webModule, AppModule appModule) throws NamingException {
        Collection webModuleResourceRefs = webModule.getWebApp().getResourceRef();
        for (ResourceRef resourceRef : webModuleResourceRefs) {
            String resourceType = resourceRef.getType();
            String resourceRefName = this.normalizeName(resourceRef.getResRefName());
            String resourceMappedName = resourceRef.getMappedName();
            String resourceName = resourceRefName;
            if (resourceMappedName != null) {
                resourceName = this.normalizeName(resourceMappedName);
            }
            if (null == resourceType || resourceType.isEmpty()) {
                throw new NamingException("The resource type for resource with " + this.printContextInformation(resourceRef, appModule, webModule) + " " + "is null or empty.");
            }
            if (this.isResourceMemberOf(this.resourceBlackList, resourceType)) {
                if (!logger.isLoggable(Level.CONFIG)) continue;
                logger.log(Level.CONFIG, "The resource type associated with " + this.printContextInformation(resourceRef, appModule, webModule) + "' " + "is present in the resource type black-list. " + "Skipping resource configuration.");
                continue;
            }
            if (!this.isResourceMemberOf(this.resourceWhiteList, resourceType)) {
                if (!logger.isLoggable(Level.CONFIG)) continue;
                logger.log(Level.CONFIG, "The resource type associated with " + this.printContextInformation(resourceRef, appModule, webModule) + "' " + "is not present in the resource type white-list. " + "Skipping resource configuration.");
                continue;
            }
            Resource existingResource = this.findResource(appModule, resourceName);
            if (null != existingResource) {
                if (!logger.isLoggable(Level.CONFIG)) continue;
                logger.log(Level.CONFIG, "Resource associated with " + this.printContextInformation(resourceRef, appModule, webModule) + "' " + "already exists: " + this.printResource(existingResource) + " " + "Skipping configuration.");
                continue;
            }
            Resource resource = new Resource(resourceName);
            resource.setType(resourceType);
            resource.setProvider(this.configurationProvider.getConfiguration(CONFIG_RESOURCE_PROVIDER, DEFAULT_RESOURCE_PROVIDER));
            resource.getProperties().put("appName", this.getWebModuleId(webModule));
            Reference reference = new Reference(resourceType);
            reference.add(new StringRefAddr("ResourceRefName", resourceRefName));
            reference.add(new StringRefAddr("mappedName", resourceRef.getMappedName()));
            resource.getProperties().put("reference", reference);
            resource.getProperties().put("factory", this.configurationProvider.getConfiguration("com.sap.cloud.runtime.kotee.deployer.object_factory", "com.sap.cloud.runtime.kotyo.tomcat.support.DelegatingObjectFactory"));
            CompositeName name = new CompositeName(this.getResourceName(resourceRefName));
            resource.getProperties().put("name", name);
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "Created resource definition for resource with " + this.printContextInformation(resourceRef, appModule, webModule));
            }
            appModule.getResources().add(resource);
        }
    }

    private boolean isResourceMemberOf(Collection<String> resources, String resourceType) {
        for (String prefix : resources) {
            if (!resourceType.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private String printContextInformation(ResourceRef resourceRef, AppModule appModule, WebModule webModule) {
        return "ResourceRef '" + this.printResourceRef(resourceRef) + "' " + "in WebApp '" + webModule.getWebApp().getId() + "' " + "with WebModule '" + webModule.getModuleId() + "' " + "with AppModule '" + appModule.getModuleId() + "'";
    }
}

