/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.lib.sso2;

import com.sap.core.jpaas.security.lib.sso2.CodePages;
import com.sap.core.jpaas.security.lib.sso2.TicketException;
import com.sap.core.jpaas.security.lib.sso2.impl.AbstractTicket;
import com.sap.core.jpaas.security.lib.sso2.internal.Implementation;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SSO2TicketFactory
extends CodePages {
    private static final Integer DEFAULT_TICKET_VALIDITY = 2;
    private static final String KEY_ALGORITHM_DSA = "DSA";
    private static final Logger LOCATION = Logger.getLogger(SSO2TicketFactory.class.getName());
    private static final SSO2TicketFactory INSTANCE = new SSO2TicketFactory();

    private SSO2TicketFactory() {
    }

    public static SSO2TicketFactory getInstance() {
        return INSTANCE;
    }

    public byte[] createAssertionTicket(String issuerSystemID, String issuerClient, String recipientSystemID, String recipientClient, String remoteUser, PrivateKey signingKey, X509Certificate certificate) throws TicketException {
        return this.createAssertionTicket(issuerSystemID, issuerClient, recipientSystemID, recipientClient, remoteUser, signingKey, certificate, null, null);
    }

    public byte[] createAssertionTicket(String issuerSystemID, String issuerClient, String recipientSystemID, String recipientClient, String remoteUser, PrivateKey signingKey, X509Certificate certificate, Integer ticketValidity, String codepage) throws TicketException {
        if (this.isEmpty(issuerSystemID)) {
            throw new IllegalArgumentException("Parameter issuingSystemID could not be empty");
        }
        if (this.isEmpty(issuerClient)) {
            throw new IllegalArgumentException("Parameter issuingClient could not be empty");
        }
        if (this.isEmpty(recipientSystemID)) {
            throw new IllegalArgumentException("Parameter recipientSystemID could not be empty");
        }
        if (this.isEmpty(recipientClient)) {
            throw new IllegalArgumentException("Parameter recipientClient could not be empty");
        }
        if (this.isEmpty(remoteUser)) {
            throw new IllegalArgumentException("Parameter remoteUser could not be empty");
        }
        if (signingKey == null) {
            throw new IllegalArgumentException("Parameter signingKey could not be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Parameter certificate could not be null");
        }
        if (!KEY_ALGORITHM_DSA.equals(signingKey.getAlgorithm())) {
            throw new IllegalArgumentException("Invalid signing key algorithm: " + signingKey.getAlgorithm() + ". Should be: " + KEY_ALGORITHM_DSA);
        }
        if (ticketValidity == null || ticketValidity < 1) {
            ticketValidity = DEFAULT_TICKET_VALIDITY;
        }
        try {
            AbstractTicket sapAssertionTicket = Implementation.createTicket();
            if (!this.isEmpty(codepage)) {
                sapAssertionTicket.setCodepage(codepage);
            }
            sapAssertionTicket.setSystemClient(issuerClient);
            sapAssertionTicket.setSystemID(issuerSystemID);
            sapAssertionTicket.setRecipientSID(recipientSystemID);
            sapAssertionTicket.setRecipientClient(recipientClient);
            sapAssertionTicket.setUser(remoteUser);
            sapAssertionTicket.setPrivateKeyPair(signingKey, certificate);
            sapAssertionTicket.setValidTime(ticketValidity);
            byte[] result = sapAssertionTicket.generate();
            if (LOCATION.isLoggable(Level.FINE)) {
                LOCATION.fine("Created assertion ticket: \n" + sapAssertionTicket.toString());
            }
            return result;
        }
        catch (TicketException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TicketException("Could not create SSO2 assertion ticket", e);
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }
}

