/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.lib.sso2.asn1;

import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1BaseType;
import com.sap.core.jpaas.security.lib.sso2.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1ObjectID
extends ASN1BaseType {
    private String objectID;

    public ASN1ObjectID(String objectID) {
        super(6);
        this.objectID = objectID;
    }

    @Override
    protected void encodeBody(DEROutputStream output) throws IOException {
        String[] objectIdParts = this.objectID.split("\\.");
        int i = objectIdParts.length - 1;
        while (i > 1) {
            int objectIdPart = Integer.parseInt(objectIdParts[i]);
            output.write(ASN1ObjectID.encodeObjectIdPart(objectIdPart));
            --i;
        }
        long firstObjectIdPart = Long.parseLong(objectIdParts[0]);
        long secondObjectIdPart = Long.parseLong(objectIdParts[1]);
        BigInteger bigInteger = BigInteger.valueOf(firstObjectIdPart * 40L + secondObjectIdPart);
        output.write(bigInteger.toByteArray());
    }

    private static byte[] encodeObjectIdPart(int i) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(i & 0x7F);
        i >>>= 7;
        while (i > 0) {
            output.write(i | 0x80);
            i >>>= 7;
        }
        return output.toByteArray();
    }
}

