/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.lib.sso2.impl;

import com.sap.core.jpaas.security.lib.sso2.CodePages;
import com.sap.core.jpaas.security.lib.sso2.TicketException;
import com.sap.core.jpaas.security.lib.sso2.impl.InfoUnit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public abstract class AbstractTicket {
    private String codepage = CodePages.getCodepage(null);
    private PrivateKey key;
    private X509Certificate certificate;
    protected ArrayList<InfoUnit> infoUnits = new ArrayList();

    public void setCodepage(String codepage) {
        this.codepage = CodePages.getCodepage(codepage);
    }

    public void setRecipientClient(String recipientClient) throws TicketException {
        try {
            this.addInfoUnit(15, recipientClient, "4110");
        }
        catch (IOException ioe) {
            throw new TicketException("Unable to serialize recipient system client!", ioe);
        }
    }

    public void setRecipientSID(String recipientSystemID) throws TicketException {
        try {
            this.addInfoUnit(16, recipientSystemID, "4110");
        }
        catch (IOException ioe) {
            throw new TicketException("Unable to serialize recipient system ID!", ioe);
        }
    }

    public void setSystemClient(String issuerClient) throws TicketException {
        try {
            this.addInfoUnit(2, issuerClient, this.codepage);
        }
        catch (IOException ioe) {
            throw new TicketException("Unable to serialize issuer system client!", ioe);
        }
    }

    public void setSystemID(String issuerSystemID) throws TicketException {
        try {
            this.addInfoUnit(3, issuerSystemID, this.codepage);
        }
        catch (IOException ioe) {
            throw new TicketException("Unable to serialize issuer system ID!", ioe);
        }
    }

    public void setUser(String remoteUser) throws TicketException {
        try {
            this.addInfoUnit(1, remoteUser, this.codepage);
            this.addInfoUnit(10, remoteUser, "4110");
        }
        catch (IOException ioe) {
            throw new TicketException("Unable to serialize user name!", ioe);
        }
    }

    public void setPrivateKeyPair(PrivateKey key, X509Certificate cert) {
        this.key = key;
        this.certificate = cert;
    }

    public void setValidTime(int minutes) throws TicketException {
        if (minutes < 0 || minutes > 59) {
            throw new TicketException("Invalid argument format. Minutes must be between 0 and 59.");
        }
        InfoUnit unit = new InfoUnit(7, AbstractTicket.intToBytes(minutes));
        this.infoUnits.add(unit);
    }

    public void addInfoUnit(InfoUnit unit) {
        this.infoUnits.add(unit);
    }

    public byte[] generate() throws TicketException, UnsupportedEncodingException, IOException {
        this.setNonCacheable();
        this.setCreationTime();
        ByteArrayOutputStream ticketStream = new ByteArrayOutputStream(256);
        ticketStream.write(2);
        ticketStream.write(this.codepage.charAt(0));
        ticketStream.write(this.codepage.charAt(1));
        ticketStream.write(this.codepage.charAt(2));
        ticketStream.write(this.codepage.charAt(3));
        for (InfoUnit unit : this.infoUnits) {
            this.write(ticketStream, unit.getID(), unit.getContent());
        }
        ticketStream.flush();
        byte[] signature = this.sign(this.key, this.certificate, ticketStream.toByteArray());
        this.write(ticketStream, 255, signature);
        ticketStream.flush();
        return ticketStream.toByteArray();
    }

    protected abstract byte[] sign(PrivateKey var1, X509Certificate var2, byte[] var3) throws TicketException;

    private void setNonCacheable() {
        this.addInfoUnit(new InfoUnit(8, new byte[]{1}));
    }

    private void setCreationTime() throws IOException, TicketException {
        Calendar utcCalendar = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        StringBuilder utcCreationTime = new StringBuilder(20);
        utcCreationTime.append(utcCalendar.get(1));
        MessageFormat mf = new MessageFormat("{0,number,00}");
        Object[] objs = new Object[]{new Integer(utcCalendar.get(2) + 1)};
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(5));
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(11));
        utcCreationTime.append(mf.format(objs));
        objs[0] = new Integer(utcCalendar.get(12));
        utcCreationTime.append(mf.format(objs));
        this.addInfoUnit(4, utcCreationTime.toString(), this.codepage);
    }

    public static byte[] intToBytes(int i) {
        byte[] b = new byte[4];
        b[3] = (byte)(i % 256);
        b[2] = (byte)((i /= 256) % 256);
        b[1] = (byte)((i /= 256) % 256);
        b[0] = (byte)((i /= 256) % 256);
        i /= 256;
        return b;
    }

    private void write(OutputStream stream, int id, byte[] contents) throws IOException {
        stream.write(id);
        stream.write(contents.length / 256 & 0xFF);
        stream.write(contents.length % 256 & 0xFF);
        stream.write(contents);
    }

    private void addInfoUnit(int id, String value, String codepage) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, CodePages.getEncoding(codepage));
            writer.write(value);
            writer.flush();
            InfoUnit unit = new InfoUnit(id, baos.toByteArray());
            this.infoUnits.add(unit);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("SSO2 Assertion Ticket:");
        for (InfoUnit unit : this.infoUnits) {
            try {
                String line = unit.toString(this.codepage);
                if (line == null) continue;
                s.append("\n\t");
                s.append(line);
            }
            catch (IOException e) {
                s.append(unit.getID());
                s.append(": ");
                s.append(e.getClass().getSimpleName());
                s.append(": ");
                s.append(e.getMessage());
            }
        }
        s.append("\n\timplementation: ");
        s.append(this.getClass().getName());
        return s.toString();
    }
}

