/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.lib.sso2.impl;

import com.sap.core.jpaas.security.lib.sso2.CodePages;
import java.io.UnsupportedEncodingException;

public class InfoUnit {
    public static final int ID_USER = 1;
    public static final int ID_CREATE_CLIENT = 2;
    public static final int ID_CREATE_NAME = 3;
    public static final int ID_CREATE_TIME = 4;
    public static final int ID_VALID_TIME_MIN = 7;
    public static final int ID_FLAGS = 8;
    public static final int ID_SIGNATURE = 255;
    public static final int ID_USER_UTF = 10;
    public static final int ID_RECIPIENT_CLIENT = 15;
    public static final int ID_RECIPIENT_SID = 16;
    private int id;
    private byte[] content;

    public InfoUnit(int id, byte[] data) {
        this.id = id;
        this.content = data;
    }

    public int getID() {
        return this.id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String toString(String codepage) throws UnsupportedEncodingException {
        switch (this.getID()) {
            case 1: {
                return "user: " + new String(this.content, CodePages.getEncoding(codepage));
            }
            case 10: {
                return "user (UTF-8): " + new String(this.content, CodePages.getEncoding("4110"));
            }
            case 3: {
                return "issuing system ID: " + new String(this.content, CodePages.getEncoding(codepage));
            }
            case 2: {
                return "issuing system client: " + new String(this.content, CodePages.getEncoding(codepage));
            }
            case 16: {
                return "recipient system ID: " + new String(this.content, CodePages.getEncoding("4110"));
            }
            case 15: {
                return "recipient system client: " + new String(this.content, CodePages.getEncoding("4110"));
            }
            case 4: {
                return "creation time (yyyymmddhhmm): " + new String(this.content, "UTF-8");
            }
            case 7: {
                int min = this.content[0];
                min *= 256;
                min += this.content[1];
                min *= 256;
                min += this.content[2];
                min *= 256;
                return "valid: " + (min += this.content[3]) + " minutes";
            }
        }
        return null;
    }
}

