/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.lib.sso2.impl;

import com.sap.core.jpaas.security.lib.sso2.TicketException;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Attribute;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Constants;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1ContextSpecificTag;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Integer;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1ObjectID;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1OctetString;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Sequence;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Set;
import com.sap.core.jpaas.security.lib.sso2.asn1.ASN1Utils;
import com.sap.core.jpaas.security.lib.sso2.impl.AbstractTicket;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

public class TicketSAPImpl
extends AbstractTicket {
    @Override
    protected byte[] sign(PrivateKey sKey, X509Certificate mCert, byte[] tbsData) throws TicketException {
        try {
            ASN1Sequence signature = new ASN1Sequence();
            signature.addSubElement(new ASN1ObjectID("1.2.840.113549.1.7.2"));
            ASN1Sequence signedData = new ASN1Sequence();
            ASN1ContextSpecificTag cs = new ASN1ContextSpecificTag(0, signedData, false);
            signature.addSubElement(cs);
            signedData.addSubElement(new ASN1Integer(1L));
            ASN1Set sha1AlgorithmSet = new ASN1Set();
            sha1AlgorithmSet.addSubElement(ASN1Constants.ASN1_ALGORITHM_IDENTIFIER_SHA1);
            signedData.addSubElement(sha1AlgorithmSet);
            ASN1Sequence contentInfo = new ASN1Sequence();
            contentInfo.addSubElement(new ASN1ObjectID("1.2.840.113549.1.7.1"));
            signedData.addSubElement(contentInfo);
            ASN1Set set = new ASN1Set();
            ASN1Sequence signedInfo = new ASN1Sequence();
            set.addSubElement(signedInfo);
            signedData.addSubElement(set);
            signedInfo.addSubElement(new ASN1Integer(1L));
            signedInfo.addSubElement(ASN1Utils.extractIssuerAndSerial(mCert));
            signedInfo.addSubElement(ASN1Constants.ASN1_ALGORITHM_IDENTIFIER_SHA1);
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(tbsData);
            byte[] firstDigest = md.digest();
            ASN1Set authnAttributes = new ASN1Set();
            authnAttributes.addSubElement(new ASN1Attribute(new ASN1ObjectID("1.2.840.113549.1.9.3"), new ASN1ObjectID("1.2.840.113549.1.7.1")));
            authnAttributes.addSubElement(new ASN1Attribute(new ASN1ObjectID("1.2.840.113549.1.9.5"), ASN1Utils.getCurrentTime()));
            authnAttributes.addSubElement(new ASN1Attribute(new ASN1ObjectID("1.2.840.113549.1.9.4"), new ASN1OctetString(firstDigest)));
            byte[] authnAttributesDER = ASN1Utils.encodeDER(authnAttributes);
            md.reset();
            md.update(authnAttributesDER);
            byte[] b = md.digest();
            Signature dsa = Signature.getInstance("RawDSA");
            dsa.initSign(sKey);
            dsa.update(b);
            byte[] signedRawData = dsa.sign();
            signedInfo.addSubElement(new ASN1ContextSpecificTag(0, authnAttributes, true));
            ASN1Sequence digestAlgorithmIdentifier = new ASN1Sequence();
            digestAlgorithmIdentifier.addSubElement(new ASN1ObjectID("1.2.840.10040.4.3"));
            signedInfo.addSubElement(digestAlgorithmIdentifier);
            signedInfo.addSubElement(new ASN1OctetString(signedRawData));
            return ASN1Utils.encodeDER(signature);
        }
        catch (IOException e) {
            throw new TicketException("Unable to sign the ticket", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TicketException("Unable to sign the ticket", e);
        }
        catch (InvalidKeyException e) {
            throw new TicketException("Unable to sign the ticket", e);
        }
        catch (SignatureException e) {
            throw new TicketException("Unable to sign the ticket", e);
        }
    }
}

