/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.passport;

import com.sap.jdsr.passport.DSRPassportApplVarPart;
import com.sap.jdsr.passport.EncodeDecode;
import com.sap.jdsr.util.ConvertHelper;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrISubRecordCert;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSRPassport
implements DsrIPassport {
    private static final String NA_STRING = "N.A";
    private int traceFlag = 0;
    private int serviceType = 0;
    private int actionType = 0;
    private String systemId = null;
    private String prevSystemId = null;
    private String action = null;
    private String userId = null;
    private String transId = null;
    private String client = null;
    private String connectionId = null;
    private String rootContextId = null;
    protected int connectionCounter = 0;
    private byte[] systemIdByte = null;
    private byte[] prevSystemIdByte = null;
    private byte[] actionByte = null;
    private byte[] userIdByte = null;
    private byte[] transIdByte = null;
    private byte[] clientByte = null;
    protected byte[] connectionIdByte = null;
    private int systemType = 2;
    private byte[] rootContextIdByte = null;
    private int version = 0;
    private ArrayList<DSRPassportApplVarPart> sysVarItems = new ArrayList();
    private ArrayList<DSRPassportApplVarPart> appVarItems = new ArrayList();
    private int appVarItemsLength = 0;
    private int sysVarItemsLength = 0;

    @Override
    public void clear() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean setByNetPassport(byte[] netPassport) {
        return false;
    }

    @Override
    public byte[] getNetPassport() {
        return EncodeDecode.encodeBytePassport(this);
    }

    public byte[] getNetPassport(byte[] connId, int connectionCounter) {
        return EncodeDecode.encodeBytePassport(this, connId, connectionCounter);
    }

    @Override
    public void setByPassport(DsrIPassport passport) {
    }

    @Override
    public void setByCert(DsrISubRecordCert cert) {
    }

    @Override
    public DsrISubRecordCert getSubRecordCert() {
        return null;
    }

    @Override
    public boolean setTransId(String transid) {
        return true;
    }

    @Override
    public String getTransId() {
        if (this.transId == null && this.transIdByte != null) {
            this.transId = new String(this.transIdByte, 0, this.transIdByte.length).trim();
        }
        return this.transId;
    }

    @Override
    public void setTraceFlag(int traceflag) {
        this.traceFlag = traceflag;
    }

    @Override
    public void addSATToTraceFlag() {
    }

    @Override
    public void removeSATFromFraceFlag() {
    }

    @Override
    public boolean isSATSetInTraceFlag() {
        return false;
    }

    @Override
    public int getTraceFlag() {
        return this.traceFlag;
    }

    @Override
    public void setService(int srv) {
    }

    @Override
    public int getService() {
        return this.serviceType;
    }

    @Override
    public void setActionType(int actiontype) {
    }

    @Override
    public int getActionType() {
        return this.actionType;
    }

    @Override
    public boolean setCompName(String compname) {
        return false;
    }

    @Override
    public String getCompName() {
        if (this.systemId != null) {
            return this.systemId;
        }
        if (this.systemId == null && this.systemIdByte != null) {
            this.systemId = new String(this.systemIdByte);
        }
        return this.systemId;
    }

    @Override
    public boolean setPrevCompName(String prevcompname) {
        return false;
    }

    @Override
    public String getPrevCompName() {
        if (this.prevSystemId != null) {
            return this.prevSystemId;
        }
        if (this.prevSystemId == null && this.prevSystemIdByte != null) {
            this.prevSystemId = new String(this.prevSystemIdByte);
        }
        return this.prevSystemId;
    }

    @Override
    public boolean setAction(String action) {
        return false;
    }

    @Override
    public String getAction() {
        if (this.action != null) {
            return this.action;
        }
        if (this.actionByte != null) {
            this.action = new String(this.actionByte);
        }
        return this.action;
    }

    @Override
    public boolean setUserId(String userid) {
        return false;
    }

    @Override
    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        if (this.userIdByte != null) {
            this.userId = new String(this.userIdByte);
        }
        return this.userId;
    }

    @Override
    public int getConnectionCounter() {
        return this.connectionCounter;
    }

    public byte[] getClientNumberBytes() {
        return this.clientByte;
    }

    @Override
    public String getClientNumber() {
        if (this.client == null && this.clientByte != null && this.clientByte.length > 0) {
            this.client = this.clientByte[0] == 0 ? NA_STRING : new String(this.clientByte);
        }
        return this.client;
    }

    @Override
    public int getSystemType() {
        return this.systemType;
    }

    public byte[] getSystemIdBytes() {
        return this.systemIdByte;
    }

    public byte[] getPrevSystemIdBytes() {
        return this.prevSystemIdByte;
    }

    public byte[] getUserIdBytes() {
        return this.userIdByte;
    }

    public byte[] getTransIdBytes() {
        return this.transIdByte;
    }

    public byte[] getActionBytes() {
        return this.actionByte;
    }

    @Override
    public byte[] getRootContextIdBytes() {
        return this.rootContextIdByte;
    }

    @Override
    public byte[] getConnectionIdBytes() {
        return this.connectionIdByte;
    }

    @Override
    public void setConnectionCounter(int connectionCounter) {
    }

    @Override
    public void setConnectionIdBytes(byte[] connectionIdByte) {
    }

    @Override
    public String getConnectionIdHex() {
        if (this.connectionId == null && this.connectionIdByte != null) {
            this.connectionId = ConvertHelper.byteArrayToHex(this.connectionIdByte);
        }
        return this.connectionId;
    }

    @Override
    public String getRootContextIdHex() {
        if (this.rootContextId == null && this.rootContextIdByte != null) {
            this.rootContextId = ConvertHelper.byteArrayToHex(this.rootContextIdByte);
        }
        return this.rootContextId;
    }

    public void setVesrionInternal(int version) {
        this.version = version;
    }

    public void setTraceFlagInternal(int traceFlag) {
        this.traceFlag = traceFlag;
    }

    public void setSystemIdInternal(String systemId) {
        if (systemId != null) {
            int len = this.userId.length();
            if (len > 32) {
                len = 32;
            }
            this.systemId = systemId;
            this.systemIdByte = new byte[len];
            System.arraycopy(systemId.getBytes(), 0, this.systemIdByte, 0, len);
        }
    }

    public void setServiceTypeInternal(int serviceType) {
        this.serviceType = serviceType;
    }

    public void setUserIdInternal(String userId) {
        if (userId != null) {
            int len = userId.length();
            if (len > 32) {
                len = 32;
            }
            this.userId = userId;
            this.userIdByte = new byte[len];
            System.arraycopy(userId.getBytes(), 0, this.userIdByte, 0, len);
        }
    }

    public void setActionInternal(String action) {
        if (action != null) {
            int len = action.length();
            if (len > 40) {
                len = 40;
            }
            this.action = action;
            this.actionByte = new byte[len];
            System.arraycopy(action.getBytes(), 0, this.actionByte, 0, len);
        }
    }

    public void setActionTypeInternal(int actionType) {
        this.actionType = actionType;
    }

    public void setPrevSystemIdInternal(String prevSystemId) {
        if (prevSystemId != null) {
            int len = prevSystemId.length();
            if (len > 32) {
                len = 32;
            }
            this.prevSystemId = prevSystemId;
            this.prevSystemIdByte = new byte[len];
            System.arraycopy(prevSystemId.getBytes(), 0, this.prevSystemIdByte, 0, len);
        }
    }

    public void setTransIdInternal(String transId) {
        if (transId != null) {
            int len = transId.length();
            if (len > 32) {
                len = 32;
            }
            this.transId = transId;
            this.transIdByte = new byte[len];
            System.arraycopy(transId.getBytes(), 0, this.transIdByte, 0, len);
        }
    }

    public void setTransIdBytesInternal(byte[] transIdBytes) {
        int len = transIdBytes.length;
        if (len > 32) {
            len = 32;
        }
        this.transIdByte = new byte[len];
        System.arraycopy(transIdBytes, 0, this.transIdByte, 0, len);
        this.transId = null;
    }

    public void setClientBytesInternal(byte[] clientBytes) {
        int len = clientBytes.length;
        if (len > 3) {
            len = 3;
        }
        this.clientByte = new byte[len];
        System.arraycopy(clientBytes, 0, this.clientByte, 0, len);
        this.client = null;
    }

    public void setSystemTypeInternal(int systemType) {
        this.systemType = systemType;
    }

    public void setRootContextIdBytesInternal(byte[] rootContextIdBytes) {
        int len = rootContextIdBytes.length;
        if (len > 16) {
            len = 16;
        }
        this.rootContextIdByte = new byte[len];
        System.arraycopy(rootContextIdBytes, 0, this.rootContextIdByte, 0, len);
        this.rootContextId = null;
    }

    public void setConnectionIdBytesInternal(byte[] connectionIdBytes) {
        int len = connectionIdBytes.length;
        if (len > 16) {
            len = 16;
        }
        this.connectionIdByte = new byte[len];
        System.arraycopy(connectionIdBytes, 0, this.connectionIdByte, 0, len);
        this.connectionId = null;
    }

    public void setConnectionCounterInternal(int connectionCounter) {
        this.connectionCounter = connectionCounter;
    }

    public DSRPassport() {
    }

    public DSRPassport(int version, int traceFlag, byte[] systemId, int service, byte[] user, byte[] action, int actionType, byte[] prevSystemId, byte[] transId, byte[] clientNumber, int systemType, byte[] rootContextId, byte[] connectionId, int connectionCounter) {
        this.setByFields(version, traceFlag, systemId, service, user, action, actionType, prevSystemId, transId, clientNumber, systemType, rootContextId, connectionId, connectionCounter);
    }

    public DSRPassport(int version, int traceFlag, String systemId, int service, String user, String action, int actionType, String prevSystemId, String transId, String clientNumber, int systemType, byte[] rootContextId, byte[] connectionId, int connectionCounter) {
        byte[] systemIdTmp = null;
        if (systemId != null) {
            systemIdTmp = systemId.getBytes();
        }
        byte[] userTmp = null;
        if (user != null) {
            userTmp = user.getBytes();
        }
        byte[] actionTmp = null;
        if (action != null) {
            actionTmp = action.getBytes();
        }
        byte[] prevSystemIdTmp = null;
        if (prevSystemId != null) {
            prevSystemIdTmp = prevSystemId.getBytes();
        }
        byte[] transIdTmp = null;
        if (transId != null) {
            transIdTmp = transId.getBytes();
        }
        byte[] clientNumberTmp = null;
        if (clientNumber != null) {
            clientNumberTmp = clientNumber.getBytes();
        }
        this.setByFields(version, traceFlag, systemIdTmp, service, userTmp, actionTmp, actionType, prevSystemIdTmp, transIdTmp, clientNumberTmp, systemType, rootContextId, connectionId, connectionCounter);
    }

    public void setPassport(DSRPassport pass) {
        this.setByFields(3, pass.getTraceFlag(), pass.getSystemIdBytes(), pass.getService(), pass.getUserIdBytes(), pass.getActionBytes(), pass.getActionType(), pass.getPrevSystemIdBytes(), pass.getTransIdBytes(), pass.getClientNumberBytes(), pass.getSystemType(), pass.getRootContextIdBytes(), null, 0);
        DSRPassportApplVarPart[] varParts = pass.getVarItems();
        if (varParts.length > 0) {
            int i = 0;
            while (i < varParts.length) {
                if (varParts[i].getVarPartType() == 1) {
                    this.sysVarItems.add(varParts[i]);
                } else {
                    this.appVarItems.add(varParts[i]);
                }
                ++i;
            }
            this.sysVarItemsLength = pass.getSysVarItemsLength();
            this.appVarItemsLength = pass.getAppVarItemsLength();
        }
    }

    public void setByFields(int version, int traceFlag, byte[] systemId, int service, byte[] user, byte[] action, int actionType, byte[] prevSystemId, byte[] transId, byte[] clientNumber, int systemType, byte[] rootContextId, byte[] connectionId, int connectionCounter) {
        int len = 0;
        this.version = version;
        this.traceFlag = traceFlag;
        if (systemId != null) {
            len = systemId.length;
            if (len > 32) {
                len = 32;
            }
            this.systemIdByte = new byte[len];
            System.arraycopy(systemId, 0, this.systemIdByte, 0, len);
        }
        this.serviceType = service;
        if (user != null) {
            len = user.length;
            if (len > 32) {
                len = 32;
            }
            this.userIdByte = new byte[len];
            System.arraycopy(user, 0, this.userIdByte, 0, len);
        }
        if (action != null) {
            len = action.length;
            if (len > 40) {
                len = 40;
            }
            this.actionByte = new byte[len];
            System.arraycopy(action, 0, this.actionByte, 0, len);
        }
        this.actionType = actionType;
        if (prevSystemId != null) {
            len = prevSystemId.length;
            if (len > 32) {
                len = 32;
            }
            this.prevSystemIdByte = new byte[len];
            System.arraycopy(prevSystemId, 0, this.prevSystemIdByte, 0, len);
        }
        if (transId != null) {
            len = transId.length;
            if (len > 32) {
                len = 32;
            }
            this.transIdByte = new byte[len];
            System.arraycopy(transId, 0, this.transIdByte, 0, len);
        }
        if (clientNumber != null) {
            len = clientNumber.length;
            if (len > 3) {
                len = 3;
            }
            this.clientByte = new byte[len];
            System.arraycopy(clientNumber, 0, this.clientByte, 0, len);
        }
        this.systemType = systemType;
        if (rootContextId != null) {
            len = rootContextId.length;
            if (len > 16) {
                len = 16;
            }
            this.rootContextIdByte = new byte[len];
            System.arraycopy(rootContextId, 0, this.rootContextIdByte, 0, len);
        }
        if (connectionId != null) {
            len = connectionId.length;
            if (len > 16) {
                len = 16;
            }
            this.connectionIdByte = new byte[len];
            System.arraycopy(connectionId, 0, this.connectionIdByte, 0, len);
        }
        this.connectionCounter = connectionCounter;
    }

    @Override
    public DSRPassportApplVarPart[] getVarItems() {
        DSRPassportApplVarPart[] temp = new DSRPassportApplVarPart[this.sysVarItems.size() + this.appVarItems.size()];
        int pos = 0;
        int i = 0;
        while (i < this.sysVarItems.size()) {
            temp[pos] = this.sysVarItems.get(i);
            ++pos;
            ++i;
        }
        int j = 0;
        while (j < this.appVarItems.size()) {
            temp[pos] = this.appVarItems.get(j);
            ++pos;
            ++j;
        }
        return temp;
    }

    public void addVarItem(DSRPassportApplVarPart applVar) {
        if (applVar == null) {
            return;
        }
        this.appVarItems.add(applVar);
        this.appVarItemsLength += applVar.getLength();
    }

    @Override
    public void addVarItemBytes(int applId, int applKey, byte[] bValue) {
        DSRPassportApplVarPart applVar = new DSRPassportApplVarPart(applId, applKey, bValue);
        this.appVarItems.add(applVar);
        this.appVarItemsLength += applVar.getLength();
    }

    @Override
    public void addVarItemInteger(int applId, int applKey, int iValue) {
        DSRPassportApplVarPart applVar = new DSRPassportApplVarPart(applId, applKey, iValue);
        this.appVarItems.add(applVar);
        this.appVarItemsLength += applVar.getLength();
    }

    @Override
    public void addVarItemString(int applId, int applKey, String sValue) {
        DSRPassportApplVarPart applVar = new DSRPassportApplVarPart(applId, applKey, sValue);
        this.appVarItems.add(applVar);
        this.appVarItemsLength += applVar.getLength();
    }

    @Override
    public void addVarItemGUID(int applId, int applKey, byte[] bValue) {
        DSRPassportApplVarPart applVar;
        if (bValue.length > 16) {
            byte[] tempByte = new byte[16];
            System.arraycopy(bValue, 0, tempByte, 0, 16);
            applVar = new DSRPassportApplVarPart(applId, applKey, tempByte);
        } else {
            applVar = new DSRPassportApplVarPart(applId, applKey, bValue);
        }
        applVar.setType(3);
        this.appVarItems.add(applVar);
        this.appVarItemsLength += applVar.getLength();
    }

    public void addSystemVarItem(DSRPassportApplVarPart sysVar) {
        if (sysVar == null) {
            return;
        }
        this.sysVarItems.add(sysVar);
        this.sysVarItemsLength += sysVar.getLength();
    }

    @Override
    public void addSystemVarItemBytes(int applId, int applKey, byte[] bValue) {
        DSRPassportApplVarPart sysVar = new DSRPassportApplVarPart(applId, applKey, bValue);
        sysVar.setVarPartType(1);
        this.sysVarItems.add(sysVar);
        this.sysVarItemsLength += sysVar.getLength();
    }

    @Override
    public void addSystemVarItemInteger(int applId, int applKey, int iValue) {
        DSRPassportApplVarPart sysVar = new DSRPassportApplVarPart(applId, applKey, iValue);
        sysVar.setVarPartType(1);
        this.sysVarItems.add(sysVar);
        this.sysVarItemsLength += sysVar.getLength();
    }

    @Override
    public void addSystemVarItemString(int applId, int applKey, String sValue) {
        DSRPassportApplVarPart sysVar = new DSRPassportApplVarPart(applId, applKey, sValue);
        sysVar.setVarPartType(1);
        this.sysVarItems.add(sysVar);
        this.sysVarItemsLength += sysVar.getLength();
    }

    @Override
    public void addSystemVarItemGUID(int applId, int applKey, byte[] bValue) {
        DSRPassportApplVarPart sysVar;
        if (bValue.length > 16) {
            byte[] tempByte = new byte[16];
            System.arraycopy(bValue, 0, tempByte, 0, 16);
            sysVar = new DSRPassportApplVarPart(applId, applKey, tempByte);
        } else {
            sysVar = new DSRPassportApplVarPart(applId, applKey, bValue);
        }
        sysVar.setType(3);
        sysVar.setVarPartType(1);
        this.sysVarItems.add(sysVar);
        this.sysVarItemsLength += sysVar.getLength();
    }

    @Override
    public DSRPassportApplVarPart getItem(int applId, int applKey) {
        DSRPassportApplVarPart varItem;
        int i = 0;
        while (i < this.sysVarItems.size()) {
            varItem = this.sysVarItems.get(i);
            if (varItem.getApplId() == applId && varItem.getKey() == applKey) {
                return varItem;
            }
            ++i;
        }
        int j = 0;
        while (j < this.appVarItems.size()) {
            varItem = this.appVarItems.get(j);
            if (varItem.getApplId() == applId && varItem.getKey() == applKey) {
                return varItem;
            }
            ++j;
        }
        return null;
    }

    public int getVarItemsLength() {
        int res = 0;
        if (this.sysVarItems.size() > 0) {
            res += this.sysVarItemsLength;
            res += 12;
        }
        if (this.appVarItems.size() > 0) {
            res += this.appVarItemsLength;
            res += 12;
        }
        return res;
    }

    public int getVarItemsCount() {
        int res = 0;
        if (this.sysVarItems.size() > 0) {
            ++res;
        }
        if (this.appVarItems.size() > 0) {
            ++res;
        }
        return res;
    }

    public List<DSRPassportApplVarPart> getSystemVariablePartItems() {
        return this.sysVarItems;
    }

    public List<DSRPassportApplVarPart> getApplicationVariablePartItems() {
        return this.appVarItems;
    }

    public int getAppVarItemsLength() {
        return this.appVarItemsLength;
    }

    public int getSysVarItemsLength() {
        return this.sysVarItemsLength;
    }
}

