/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.passport;

import com.sap.jdsr.util.ConvertHelper;

public class DSRPassportApplVarPart {
    public static final int BYTE_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int GUID_TYPE = 3;
    public static final int STRING_TYPE = 4;
    public static final int VARIABLE_PART_TYPE_SYSTEM = 1;
    public static final int VARIABLE_PART_TYPE_APPLICATION = 2;
    private int applId = 0;
    private int applKey = 0;
    private int type = 0;
    private int length = 0;
    private byte[] byteValue = null;
    private int intValue = 0;
    private String strValue = "";
    private int varPartType = 0;

    public DSRPassportApplVarPart(int applId, int applKey, byte[] bValue) {
        this.applId = applId;
        this.applKey = applKey;
        this.type = 1;
        if (bValue != null) {
            this.byteValue = new byte[bValue.length];
            System.arraycopy(bValue, 0, this.byteValue, 0, bValue.length);
            this.setLength(this.byteValue);
        }
        this.varPartType = 2;
    }

    public DSRPassportApplVarPart(int applId, int applKey, int iValue) {
        this.applId = applId;
        this.applKey = applKey;
        this.type = 2;
        this.intValue = iValue;
        this.setLength(this.intValue);
        this.varPartType = 2;
    }

    public DSRPassportApplVarPart(int applId, int applKey, String sValue) {
        this.applId = applId;
        this.applKey = applKey;
        this.type = 4;
        this.strValue = sValue;
        this.setLength(this.strValue);
        this.varPartType = 2;
    }

    public byte[] getByteArray() {
        int offset = 0;
        byte[] byteArray = new byte[this.length];
        ConvertHelper.int2TwoByte(this.applId, byteArray, offset);
        ConvertHelper.int2TwoByte(this.applKey, byteArray, offset += 2);
        ConvertHelper.int2OneByte(this.type, byteArray, offset += 2);
        ConvertHelper.int2TwoByte(this.length, byteArray, ++offset);
        offset += 2;
        if (this.type == 1 || this.type == 3) {
            System.arraycopy(this.byteValue, 0, byteArray, offset, this.byteValue.length);
        } else if (this.type == 4) {
            byte[] strBytes = this.strValue.getBytes();
            System.arraycopy(strBytes, 0, byteArray, offset, strBytes.length);
        } else if (this.type == 2) {
            ConvertHelper.int2FourByte(this.intValue, byteArray, offset);
        }
        return byteArray;
    }

    public int getApplId() {
        return this.applId;
    }

    public int getKey() {
        return this.applKey;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBytes() {
        return this.byteValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public void setApplId(int applId) {
        this.applId = applId;
    }

    public void setKey(int applKey) {
        this.applKey = applKey;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setLength(byte[] bValue) {
        this.length = 7 + bValue.length;
    }

    public void setLength(int iValue) {
        this.length = 11;
    }

    public void setLength(String strValue) {
        try {
            this.length = 7 + strValue.getBytes("UTF-8").length;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setByteValue(byte[] bValue) {
        if (bValue != null) {
            this.byteValue = new byte[bValue.length];
            System.arraycopy(bValue, 0, this.byteValue, 0, bValue.length);
        }
    }

    public void setIntValue(int intValue) {
        this.intValue = intValue;
    }

    public void setStrValue(String strValue) {
        this.strValue = strValue;
    }

    public int getVarPartType() {
        return this.varPartType;
    }

    public void setVarPartType(int varPartType) {
        this.varPartType = varPartType;
    }
}

