/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.passport;

import com.sap.jdsr.passport.Constants;
import com.sap.jdsr.passport.DSRPassport;
import com.sap.jdsr.passport.DSRPassportApplVarPart;
import com.sap.jdsr.util.ConvertHelper;
import com.sap.jdsr.util.DSRTrace;

public class EncodeDecode {
    public static byte[] encodeBytePassport(DSRPassport passport) {
        return EncodeDecode.encodeBytePassport(passport, null, 0);
    }

    public static byte[] encodeBytePassport(DSRPassport passport, byte[] connId, int connCounter) {
        int i = 0;
        int position = 0;
        int len = 230;
        byte[] res = new byte[len += passport.getVarItemsLength()];
        i = 0;
        while (i < len) {
            res[i] = 0;
            ++i;
        }
        System.arraycopy(Constants.eyeCatcher, 0, res, position, 4);
        res[position += 4] = 3;
        res[++position] = (byte)((len & 0xFF00) >> 8);
        res[position + 1] = (byte)(len & 0xFF);
        res[(position += 2) + 1] = (byte)((passport.getTraceFlag() & 0xFF00) >> 8);
        res[position] = (byte)(passport.getTraceFlag() & 0xFF);
        position += 2;
        byte[] temp = passport.getSystemIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        res[position += 32] = (byte)((passport.getService() & 0xFF00) >> 8);
        res[position + 1] = (byte)(passport.getService() & 0xFF);
        position += 2;
        temp = null;
        temp = passport.getUserIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        position += 32;
        temp = null;
        temp = passport.getActionBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        res[position += 40] = (byte)((passport.getActionType() & 0xFF00) >> 8);
        res[position + 1] = (byte)(passport.getActionType() & 0xFF);
        position += 2;
        temp = null;
        temp = passport.getPrevSystemIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        position += 32;
        temp = null;
        temp = passport.getTransIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        position += 32;
        temp = null;
        temp = passport.getClientNumberBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        res[position += 3] = (byte)((passport.getSystemType() & 0xFF00) >> 8);
        res[position + 1] = (byte)(passport.getSystemType() & 0xFF);
        position += 2;
        temp = null;
        temp = passport.getRootContextIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        position += 16;
        temp = null;
        temp = connId != null ? connId : passport.getConnectionIdBytes();
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, temp.length);
        }
        position += 16;
        int connectionCounter = 0;
        connectionCounter = connCounter != 0 ? connCounter : passport.getConnectionCounter();
        temp = new byte[4];
        ConvertHelper.int2FourByte(connectionCounter, temp, 0);
        if (temp != null) {
            System.arraycopy(temp, 0, res, position, 4);
        }
        position += 4;
        int varPartCount = passport.getVarItemsCount();
        byte[] varPartBytes = EncodeDecode.getBytesVarItems(passport);
        if (varPartCount != 0 && varPartBytes != null) {
            res[position] = (byte)((varPartCount & 0xFF00) >> 8);
            res[position + 1] = (byte)(varPartCount & 0xFF);
            int varPartOffset = (position += 2) + 2;
            res[position] = (byte)((varPartOffset & 0xFF00) >> 8);
            res[position + 1] = (byte)(varPartOffset & 0xFF);
            System.arraycopy(varPartBytes, 0, res, position += 2, varPartBytes.length);
            position += varPartBytes.length;
        } else {
            position += 4;
        }
        System.arraycopy(Constants.eyeCatcher, 0, res, position, 4);
        return res;
    }

    public static DSRPassport decodeBytePassport(byte[] netPassport) {
        int position = 0;
        byte[] sysId = null;
        byte[] prevSysId = null;
        byte[] action = null;
        byte[] userId = null;
        byte[] transId = null;
        int traceFlag = 0;
        int service = 0;
        int actionType = 0;
        byte[] rootContextId = null;
        byte[] connectionId = null;
        int connectionCounter = 0;
        byte[] clientNumber = null;
        int systemType = 0;
        int temp = 0;
        byte[] _varPart = null;
        int _varPartCount = 0;
        if (netPassport == null) {
            return null;
        }
        if (netPassport.length < 7) {
            return null;
        }
        if (EncodeDecode.arrayCmp(netPassport, 0, Constants.eyeCatcher, 0, 4) != 0) {
            return null;
        }
        int version = netPassport[position += 4];
        if (version < 0) {
            version += 256;
        }
        int len = ConvertHelper.twoByte2Int(netPassport, ++position);
        position += 2;
        if (netPassport.length != len) {
            return null;
        }
        if (version == 2) {
            if (185 != len) {
                return null;
            }
        } else if (version >= 3) {
            if (len < 230) {
                return null;
            }
        } else {
            return null;
        }
        if (EncodeDecode.arrayCmp(netPassport, len - 4, Constants.eyeCatcher, 0, 4) != 0) {
            return null;
        }
        int r1 = netPassport[position + 1];
        int r2 = netPassport[position];
        if (r1 < 0) {
            r1 += 256;
        }
        if (r2 < 0) {
            r2 += 256;
        }
        traceFlag = r1 * 256 + r2;
        position += 2;
        temp = 31;
        while (temp >= 0) {
            if (netPassport[position + temp] != 0) break;
            --temp;
        }
        sysId = new byte[temp + 1];
        System.arraycopy(netPassport, position, sysId, 0, temp + 1);
        service = ConvertHelper.twoByte2Int(netPassport, position += 32);
        position += 2;
        temp = 31;
        while (temp >= 0) {
            if (netPassport[position + temp] != 0) break;
            --temp;
        }
        userId = new byte[temp + 1];
        System.arraycopy(netPassport, position, userId, 0, temp + 1);
        position += 32;
        temp = 39;
        while (temp >= 0) {
            if (netPassport[position + temp] != 0) break;
            --temp;
        }
        action = new byte[temp + 1];
        System.arraycopy(netPassport, position, action, 0, temp + 1);
        actionType = ConvertHelper.twoByte2Int(netPassport, position += 40);
        position += 2;
        temp = 31;
        while (temp >= 0) {
            if (netPassport[position + temp] != 0) break;
            --temp;
        }
        prevSysId = new byte[temp + 1];
        System.arraycopy(netPassport, position, prevSysId, 0, temp + 1);
        position += 32;
        if (version >= 2) {
            transId = new byte[32];
            System.arraycopy(netPassport, position, transId, 0, 32);
            position += 32;
        }
        if (version >= 3) {
            int varPartLen;
            int varPartOffset;
            clientNumber = new byte[3];
            System.arraycopy(netPassport, position, clientNumber, 0, 3);
            systemType = ConvertHelper.twoByte2Int(netPassport, position += 3);
            rootContextId = new byte[16];
            System.arraycopy(netPassport, position += 2, rootContextId, 0, 16);
            connectionId = new byte[16];
            System.arraycopy(netPassport, position += 16, connectionId, 0, 16);
            connectionCounter = ConvertHelper.fourByte2Int(netPassport, position += 16);
            _varPart = null;
            _varPartCount = ConvertHelper.twoByte2Int(netPassport, position += 4);
            position += 2;
            if (_varPartCount != 0 && (varPartOffset = ConvertHelper.twoByte2Int(netPassport, position)) == (position += 2) && (varPartLen = netPassport.length - position - 4) > 0) {
                _varPart = new byte[varPartLen];
                System.arraycopy(netPassport, position, _varPart, 0, varPartLen);
            }
        }
        DSRPassport tmp = new DSRPassport(version, traceFlag, sysId, service, userId, action, actionType, prevSysId, transId, clientNumber, systemType, rootContextId, connectionId, connectionCounter);
        if (_varPart != null && _varPartCount != 0) {
            EncodeDecode.readVarItems(tmp, _varPartCount, _varPart);
        }
        return tmp;
    }

    private static byte[] getBytesVarItems(DSRPassport pass) {
        byte[] tempArr;
        DSRPassportApplVarPart tempVar;
        int i;
        int position = 0;
        byte[] allBytes = new byte[pass.getVarItemsLength()];
        if (pass.getSystemVariablePartItems().size() > 0) {
            System.arraycopy(Constants.eyeCatcher, 0, allBytes, position, 4);
            allBytes[position += 4] = 1;
            ConvertHelper.int2TwoByte(pass.getSysVarItemsLength() + 12, allBytes, ++position);
            allBytes[position += 2] = pass.getApplicationVariablePartItems().size() > 0 ? (byte)0 : 1;
            ConvertHelper.int2TwoByte(1, allBytes, ++position);
            ConvertHelper.int2TwoByte(pass.getSystemVariablePartItems().size(), allBytes, position += 2);
            position += 2;
            i = 0;
            while (i < pass.getSystemVariablePartItems().size()) {
                tempVar = pass.getSystemVariablePartItems().get(i);
                tempArr = tempVar.getByteArray();
                System.arraycopy(tempArr, 0, allBytes, position, tempArr.length);
                position += tempArr.length;
                ++i;
            }
        }
        if (pass.getApplicationVariablePartItems().size() > 0) {
            System.arraycopy(Constants.eyeCatcher, 0, allBytes, position, 4);
            allBytes[position += 4] = 1;
            ConvertHelper.int2TwoByte(pass.getAppVarItemsLength() + 12, allBytes, ++position);
            allBytes[position += 2] = 1;
            ConvertHelper.int2TwoByte(2, allBytes, ++position);
            ConvertHelper.int2TwoByte(pass.getApplicationVariablePartItems().size(), allBytes, position += 2);
            position += 2;
            i = 0;
            while (i < pass.getApplicationVariablePartItems().size()) {
                tempVar = pass.getApplicationVariablePartItems().get(i);
                tempArr = tempVar.getByteArray();
                System.arraycopy(tempArr, 0, allBytes, position, tempArr.length);
                position += tempArr.length;
                ++i;
            }
        }
        return allBytes;
    }

    private static void readVarItems(DSRPassport pass, int number, byte[] bytes) {
        int position = 0;
        int i = 0;
        while (i < number) {
            if (EncodeDecode.arrayCmp(bytes, position, Constants.eyeCatcher, 0, 4) != 0) {
                if (DSRTrace.isDumpActive()) {
                    DSRTrace.dump("Parsing variable part of teh passport faild. Eyecatcher is not correct!");
                }
                return;
            }
            byte cfr_ignored_0 = bytes[position += 4];
            ConvertHelper.twoByte2Int(bytes, ++position);
            byte cfr_ignored_1 = bytes[position += 2];
            int varPartID = ConvertHelper.twoByte2Int(bytes, ++position);
            int itemsCount = ConvertHelper.twoByte2Int(bytes, position += 2);
            position += 2;
            int j = 0;
            while (j < itemsCount) {
                int applId = ConvertHelper.twoByte2Int(bytes, position);
                int applKey = ConvertHelper.twoByte2Int(bytes, position += 2);
                int type = ConvertHelper.oneByte2Int(bytes, position += 2);
                int lengthVar = ConvertHelper.twoByte2Int(bytes, ++position);
                byte[] bValue = new byte[lengthVar - 7];
                System.arraycopy(bytes, position += 2, bValue, 0, lengthVar - 7);
                position += lengthVar - 7;
                switch (type) {
                    case 2: {
                        int iValue = ConvertHelper.fourByte2Int(bValue, 0);
                        if (varPartID == 1) {
                            pass.addSystemVarItemInteger(applId, applKey, iValue);
                            break;
                        }
                        pass.addVarItemInteger(applId, applKey, iValue);
                        break;
                    }
                    case 4: {
                        if (varPartID == 1) {
                            pass.addSystemVarItemString(applId, applKey, new String(bValue));
                            break;
                        }
                        pass.addVarItemString(applId, applKey, new String(bValue));
                        break;
                    }
                    case 3: {
                        if (varPartID == 1) {
                            pass.addSystemVarItemGUID(applId, applKey, bValue);
                            break;
                        }
                        pass.addVarItemGUID(applId, applKey, bValue);
                        break;
                    }
                    case 1: {
                        if (varPartID == 1) {
                            pass.addSystemVarItemBytes(applId, applKey, bValue);
                            break;
                        }
                        pass.addVarItemBytes(applId, applKey, bValue);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static int arrayCmp(byte[] a1, int startPositionA, byte[] a2, int startPositionB, int numberOfBytesToCompare) {
        int i = 0;
        while (i < numberOfBytesToCompare) {
            if (a1[startPositionA + i] != a2[startPositionB + i]) {
                return a1[startPositionA + i] - a2[startPositionB + i];
            }
            ++i;
        }
        return 0;
    }
}

