/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public class DSRTrace {
    private static Logger logger = Logger.getLogger(DSRTrace.class);
    public static final String DUMP_PREFIX = "DUMP jDSR: ";

    public static boolean isDumpActive() {
        return logger.isDebugEnabled();
    }

    public static void logError(String msg) {
        StringBuffer buffer = new StringBuffer();
        logger.error((Object)buffer.append(DUMP_PREFIX).append(Thread.currentThread().getName()).append(": ").append(msg).substring(0));
    }

    public static void logError(Exception e) {
        if (e != null) {
            logger.error((Object)DSRTrace.stacktraceToString(e));
        }
    }

    public static void dump(String msg) {
        StringBuffer buffer = new StringBuffer();
        logger.debug((Object)buffer.append(DUMP_PREFIX).append(Thread.currentThread().getName()).append(": ").append(msg).substring(0));
    }

    public static void dumpError(Exception e) {
        if (e != null) {
            logger.debug((Object)DSRTrace.stacktraceToString(e));
        }
    }

    private static String stacktraceToString(Throwable th) {
        StringWriter writer0 = new StringWriter(1024);
        PrintWriter writer1 = new PrintWriter(writer0);
        th.printStackTrace(writer1);
        writer0.flush();
        return writer0.toString();
    }
}

