/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring;

import com.sap.core.js.monitoring.IMBeansFactory;
import com.sap.core.js.monitoring.heap.HeapOperations;
import com.sap.core.js.monitoring.request.RequestProcessorMetrics;
import com.sap.core.js.monitoring.sapjvm.SAPJVMMetrics;
import com.sap.core.js.monitoring.sapjvm.debug.DebugOperations;
import com.sap.core.js.monitoring.threading.Threading;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeansFactory
implements IMBeansFactory {
    private static final String SAPJVM_MBEAN_NAME = "com.sap.js:name=SAPJVMMetrics,type=SAPJVMMetrics";
    private static final String REQUEST_PROCESSOR_MBEAN_NAME = "com.sap.js:name=RequestProcessorMetrics,type=RequestProcessorMetrics";
    private static final String THREAD_DUMP_MBEAN_NAME = "com.sap.js:name=Threading,type=Threading";
    private static final String MBEAN_NAME_HEAP_OPERATIONS = "com.sap.js:name=HeapOperations,type=HeapOperations";
    private static final String DEBUG_MBEAN_NAME = "com.sap.default:name=DebugOperations,type=Debug";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String SAP_INDENTIFIER = "SAP";
    private HashMap<String, Object> mbeans = new HashMap();
    private static final Logger logger = Logger.getLogger(MBeansFactory.class);

    public MBeansFactory() {
        this.mbeans.put(REQUEST_PROCESSOR_MBEAN_NAME, new RequestProcessorMetrics());
        this.mbeans.put(THREAD_DUMP_MBEAN_NAME, new Threading());
        if (this.runningOnSAPJVM()) {
            this.mbeans.put(DEBUG_MBEAN_NAME, new DebugOperations());
            this.mbeans.put(SAPJVM_MBEAN_NAME, new SAPJVMMetrics());
            this.mbeans.put(MBEAN_NAME_HEAP_OPERATIONS, new HeapOperations());
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("The mbeans with names SAPJVMMetrics and DebugOperations are not supported on the current java virtual machine and will not be registered. The current JVM vendor is: " + System.getProperty(JAVA_VENDOR)));
        }
    }

    @Override
    public HashMap<String, Object> getMBeans() {
        return this.mbeans;
    }

    private boolean runningOnSAPJVM() {
        return System.getProperty(JAVA_VENDOR).contains(SAP_INDENTIFIER);
    }
}

