/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring;

import com.sap.core.js.monitoring.IMBeansFactory;
import com.sap.core.js.monitoring.MBeanTimerFinalizer;
import com.sap.core.js.monitoring.MBeansFactory;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MonitoringLifecycleHandler {
    private static final Logger logger = Logger.getLogger(MonitoringLifecycleHandler.class);
    private MBeanServer mbeanServer;
    private ObjectName[] registeredMBeans;
    private HashMap<String, Object> mbeans;

    public MonitoringLifecycleHandler() {
        this(ManagementFactory.getPlatformMBeanServer(), new MBeansFactory());
    }

    public MonitoringLifecycleHandler(MBeanServer mbeanServer, IMBeansFactory mbeansFactory) {
        this.mbeans = mbeansFactory.getMBeans();
        this.registeredMBeans = new ObjectName[this.mbeans.size()];
        this.mbeanServer = mbeanServer;
    }

    protected void start() {
        this.registerMBeans();
    }

    protected void stop() {
        this.unregisterMBeans();
        this.mbeanServer = null;
    }

    private void registerMBeans() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start registering monitoring mbeans.");
        }
        int i = 0;
        for (String mBeanName : this.mbeans.keySet()) {
            try {
                ObjectName objectName = new ObjectName(mBeanName);
                this.mbeanServer.registerMBean(this.mbeans.get(mBeanName), objectName);
                this.registeredMBeans[i++] = objectName;
            }
            catch (InstanceAlreadyExistsException e) {
                logger.warn((Object)("Cannot register mbean with object name [" + this.registeredMBeans[i] + "] as it already registered."), (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                logger.error((Object)("Cannot register mbean with object name [" + this.registeredMBeans[i] + "]."), (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                logger.error((Object)("Cannot register mbean with object name [" + this.registeredMBeans[i] + "] as it is not JMX compliant MBean ."), (Throwable)e);
            }
            catch (MalformedObjectNameException e) {
                logger.error((Object)("Cannot create object name with name [" + mBeanName + "]."), (Throwable)e);
            }
        }
        this.logRegisteredMbeans();
    }

    private void unregisterMBeans() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Star unregistering monitoring mbeans.");
        }
        int i = 0;
        while (i < this.registeredMBeans.length) {
            if (this.registeredMBeans[i] != null) {
                try {
                    this.mbeanServer.unregisterMBean(this.registeredMBeans[i]);
                    this.registeredMBeans[i] = null;
                }
                catch (MBeanRegistrationException e) {
                    logger.error((Object)("Cannot unregister mbean with object name [" + this.registeredMBeans[i] + "]."), (Throwable)e);
                }
                catch (InstanceNotFoundException e) {
                    logger.warn((Object)("Cannot unregister mbean with object name [" + this.registeredMBeans[i] + "] as it cannot be found"), (Throwable)e);
                }
            }
            ++i;
        }
        this.finalizeMbeans();
        this.logRegisteredMbeans();
    }

    private void logRegisteredMbeans() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered mbeans: [" + this.getRegisteredMBeansAsString() + "]."));
        }
    }

    String getRegisteredMBeansAsString() {
        StringBuffer sb = new StringBuffer();
        ObjectName[] objectNameArray = this.registeredMBeans;
        int n = this.registeredMBeans.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectName oName = objectNameArray[n2];
            if (oName != null) {
                sb.append(" ").append(oName).append(",");
            }
            ++n2;
        }
        return sb.toString();
    }

    final ObjectName[] getRegisteredMBeans() {
        return this.registeredMBeans;
    }

    void finalizeMbeans() {
        for (Object mBean : this.mbeans.values()) {
            if (!(mBean instanceof MBeanTimerFinalizer)) continue;
            ((MBeanTimerFinalizer)mBean).terminateTimers();
        }
    }
}

