/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.heap;

import com.sap.core.js.monitoring.heap.HeapOperationsMBean;
import com.sap.core.js.monitoring.sapjvm.VmInfoFactory;
import com.sap.jvm.monitor.vm.Vm;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class HeapOperations
implements HeapOperationsMBean {
    private static final String METHOD_NAME_DUMP_HEAP = "dumpHeap";

    public void dumpHeap() throws IOException {
        try {
            Vm vm = this.getVmReference();
            this.invokeDumpHeapOperation(vm);
        }
        catch (Exception e) {
            throw new IOException("Failed to perform a heap dump:", e);
        }
    }

    public void invokeDumpHeapOperation(Vm vm) throws IOException {
        try {
            Method heapDumpMethod = Vm.class.getMethod(METHOD_NAME_DUMP_HEAP, new Class[0]);
            heapDumpMethod.invoke((Object)vm, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getCause());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Vm getVmReference() {
        VmInfoFactory vmInfoFactory = new VmInfoFactory();
        return vmInfoFactory.getVm();
    }
}

