/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.request;

import com.sap.core.js.monitoring.request.MetricsHandler;
import com.sap.core.js.monitoring.sapjvm.IVmInfoFactory;
import com.sap.core.js.monitoring.sapjvm.MetricsDataCollector;
import java.util.Arrays;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageResponseTimeCalculator
extends MetricsDataCollector<Long> {
    private static final Logger logger = Logger.getLogger(AverageResponseTimeCalculator.class);
    private static AtomicLong requestsCount = new AtomicLong(0L);
    private static AtomicLong responsesTime = new AtomicLong(0L);
    private static AtomicLong err500Count = new AtomicLong(0L);

    public AverageResponseTimeCalculator(Timer timer, long updateInterval, long totalUpdateDuration, IVmInfoFactory vmInfoFactory) {
        super(timer, updateInterval, totalUpdateDuration, vmInfoFactory);
        MetricsHandler.provideHandler(this);
    }

    @Override
    public final void updateValues() {
        long time = responsesTime.getAndSet(0L);
        long requests = requestsCount.getAndSet(0L);
        long e500Count = err500Count.getAndSet(0L);
        if (requests != 0L) {
            this.buffer.add(time / requests);
            this.buffer2.add(requests);
        } else {
            this.buffer.add(0L);
            this.buffer2.add(0L);
        }
        if (e500Count != 0L) {
            this.buffer3.add(e500Count);
        } else {
            this.buffer3.add(0L);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateValues() : " + this.buffer.getLast()));
        }
    }

    public final long[] getAverageResponseTime(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer.elements() - numberOfProbes - 1;
        int size = this.buffer.elements();
        int startIndex = 0;
        if (first >= 0) {
            startIndex = first;
        }
        long[] result = new long[size - startIndex];
        int i = 0;
        while (i < size - startIndex) {
            result[i] = (Long)this.buffer.get(i + startIndex);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getAverageResponseTime(" + interval + ") : return " + Arrays.toString(result)));
        }
        return result;
    }

    public final long[] getRequestsCount(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer2.elements() - numberOfProbes - 1;
        int size = this.buffer2.elements();
        int startIndex = 0;
        if (first >= 0) {
            startIndex = first;
        }
        long[] result = new long[size - startIndex];
        int i = 0;
        while (i < size - startIndex) {
            result[i] = (Long)this.buffer2.get(i + startIndex);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getRequestsCount(" + interval + ") : return " + Arrays.toString(result)));
        }
        return result;
    }

    public final long[] getErr500Count(long interval) {
        if (interval > this.totalUpdateDuration) {
            throw new IllegalArgumentException("No Data available");
        }
        int numberOfProbes = (int)(interval / this.updateInterval);
        int first = this.buffer3.elements() - numberOfProbes - 1;
        int size = this.buffer3.elements();
        int startIndex = 0;
        if (first >= 0) {
            startIndex = first;
        }
        long[] result = new long[size - startIndex];
        int i = 0;
        while (i < size - startIndex) {
            result[i] = (Long)this.buffer3.get(i + startIndex);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getError500Count(" + interval + ") : return " + Arrays.toString(result)));
        }
        return result;
    }

    public void requestFinished(long responseTime) {
        this.requestFinished(responseTime, false);
    }

    public void requestFinished(long responseTime, boolean isErr500) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AverageResponseTimeCalculator.requestFinished(" + responseTime + ", " + isErr500 + ")"));
        }
        requestsCount.incrementAndGet();
        responsesTime.addAndGet(responseTime);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AverageResponseTimeCalculator.requestFinished responsesTime[" + responsesTime + "], requestsCount[" + requestsCount + "]"));
        }
        if (isErr500) {
            err500Count.incrementAndGet();
        }
    }
}

