/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.monitoring.request;

import com.sap.core.js.monitoring.MBeanTimerFinalizer;
import com.sap.core.js.monitoring.request.AverageResponseTimeCalculator;
import com.sap.core.js.monitoring.request.RequestProcessorMetricsMBean;
import java.util.Timer;
import javax.management.MBeanAttributeInfo;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

public class RequestProcessorMetrics
extends StandardMBean
implements RequestProcessorMetricsMBean,
MBeanTimerFinalizer {
    private static final long INTERVAL_1_MIN = 60000L;
    private static final long INTERVAL_60_MIN = 3600000L;
    private static final long UPDATE_INTERVAL = 60000L;
    private static final String AVERAGE_RESPONSE_TIME_MIN = "AverageResponseTimeMin";
    private static final String AVERAGE_RESPONSE_TIME_MIN_DESCR = "Returns the average response time for the last minute.";
    private static final String AVERAGE_RESPONSE_TIMES_HOUR = "AverageResponseTimesHour";
    private static final String AVERAGE_RESPONSE_TIMES_HOUR_DESCR = "Returns an array of average response times for the last hour. Each element represents the average response time for a particular minute from the given interval.";
    private static final String RESPONSE_COUNT_MIN = "RequestsCountMin";
    private static final String RESPONSE_COUNT_MIN_DESCR = "Returns the requests count for the last minute.";
    private static final String RESPONSE_COUNT_HOUR = "RequestsCountHour";
    private static final String RESPONSE_COUNT_HOUR_DESCR = "Returns an array of request count for the last hour. Each element represents the request count for a particular minute from the given interval.";
    private static final String ISE500_COUNT_MIN = "Error500CountMin";
    private static final String ISE500_COUNT_MIN_DESCR = "Returns the internal server errors count for the last minute.";
    private static final String ISE500_COUNT_HOUR = "Error500Hour";
    private static final String ISE500_COUNT_HOUR_DESCR = "Returns an array of the internal server errors count for the last hour. Each element represents the internal server errors for a particular minute from the given interval.";
    private static final Logger logger = Logger.getLogger(RequestProcessorMetrics.class);
    AverageResponseTimeCalculator artCalculator;
    final Timer metricsTimer = new Timer();

    public RequestProcessorMetrics() {
        super(RequestProcessorMetricsMBean.class, false);
        this.artCalculator = new AverageResponseTimeCalculator(this.metricsTimer, 60000L, 3600000L, null);
    }

    public final long getAverageResponseTimeMin() {
        logger.debug((Object)"getAverageResponseTimeMin operation is invoked.");
        long[] averageResponses = this.artCalculator.getAverageResponseTime(60000L);
        if (averageResponses.length <= 0) {
            return 0L;
        }
        return averageResponses[averageResponses.length - 1];
    }

    public final long[] getAverageResponseTimesHour() {
        logger.debug((Object)"getAverageResponseTimesHour operation is invoked.");
        return this.artCalculator.getAverageResponseTime(3600000L);
    }

    protected final String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        if (AVERAGE_RESPONSE_TIME_MIN.equals(name)) {
            return AVERAGE_RESPONSE_TIME_MIN_DESCR;
        }
        if (AVERAGE_RESPONSE_TIMES_HOUR.equals(name)) {
            return AVERAGE_RESPONSE_TIMES_HOUR_DESCR;
        }
        if (RESPONSE_COUNT_MIN.equals(name)) {
            return RESPONSE_COUNT_MIN_DESCR;
        }
        if (RESPONSE_COUNT_HOUR.equals(name)) {
            return RESPONSE_COUNT_HOUR_DESCR;
        }
        if (ISE500_COUNT_MIN.equals(name)) {
            return ISE500_COUNT_MIN_DESCR;
        }
        if (ISE500_COUNT_HOUR.equals(name)) {
            return ISE500_COUNT_HOUR_DESCR;
        }
        return super.getDescription(info);
    }

    public long getRequestsCountMin() {
        logger.debug((Object)"getRequestsCountMin operation is invoked.");
        long[] reqCount = this.artCalculator.getRequestsCount(60000L);
        if (reqCount.length <= 0) {
            return 0L;
        }
        return reqCount[reqCount.length - 1];
    }

    public long[] getRequestsCountHour() {
        logger.debug((Object)"getRequestsCountHour operation is invoked.");
        return this.artCalculator.getRequestsCount(3600000L);
    }

    public long getError500CountMin() {
        logger.debug((Object)"getError500CountMin operation is invoked.");
        long[] reqCount = this.artCalculator.getErr500Count(60000L);
        if (reqCount.length <= 0) {
            return 0L;
        }
        return reqCount[reqCount.length - 1];
    }

    public long[] getError500Hour() {
        logger.debug((Object)"getError500Hour operation is invoked.");
        return this.artCalculator.getErr500Count(3600000L);
    }

    public void terminateTimers() {
        if (this.metricsTimer != null) {
            this.metricsTimer.cancel();
        }
    }
}

